/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSiteAddressRequest extends OutpostsRequest implements
        ToCopyableBuilder<GetSiteAddressRequest.Builder, GetSiteAddressRequest> {
    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(GetSiteAddressRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SiteId").build()).build();

    private static final SdkField<String> ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressType").getter(getter(GetSiteAddressRequest::addressTypeAsString))
            .setter(setter(Builder::addressType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AddressType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_ID_FIELD,
            ADDRESS_TYPE_FIELD));

    private final String siteId;

    private final String addressType;

    private GetSiteAddressRequest(BuilderImpl builder) {
        super(builder);
        this.siteId = builder.siteId;
        this.addressType = builder.addressType;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * <note>
     * <p>
     * In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and sites
     * throughout the Outposts Query API. To address backwards compatibility, the parameter names <code>OutpostID</code>
     * or <code>SiteID</code> remain in use. Despite the parameter name, you can make the request with an ARN.
     * </p>
     * </note>
     * 
     * @return The ID or the Amazon Resource Name (ARN) of the site. </p> <note>
     *         <p>
     *         In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts
     *         and sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
     *         <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make the
     *         request with an ARN.
     *         </p>
     */
    public final String siteId() {
        return siteId;
    }

    /**
     * <p>
     * The type of the address you request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressType} will
     * return {@link AddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressTypeAsString}.
     * </p>
     * 
     * @return The type of the address you request.
     * @see AddressType
     */
    public final AddressType addressType() {
        return AddressType.fromValue(addressType);
    }

    /**
     * <p>
     * The type of the address you request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressType} will
     * return {@link AddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressTypeAsString}.
     * </p>
     * 
     * @return The type of the address you request.
     * @see AddressType
     */
    public final String addressTypeAsString() {
        return addressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        hashCode = 31 * hashCode + Objects.hashCode(addressTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSiteAddressRequest)) {
            return false;
        }
        GetSiteAddressRequest other = (GetSiteAddressRequest) obj;
        return Objects.equals(siteId(), other.siteId()) && Objects.equals(addressTypeAsString(), other.addressTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSiteAddressRequest").add("SiteId", siteId()).add("AddressType", addressTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        case "AddressType":
            return Optional.ofNullable(clazz.cast(addressTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSiteAddressRequest, T> g) {
        return obj -> g.apply((GetSiteAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSiteAddressRequest> {
        /**
         * <p>
         * The ID or the Amazon Resource Name (ARN) of the site.
         * </p>
         * <note>
         * <p>
         * In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and
         * sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
         * <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make the
         * request with an ARN.
         * </p>
         * </note>
         * 
         * @param siteId
         *        The ID or the Amazon Resource Name (ARN) of the site. </p> <note>
         *        <p>
         *        In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts
         *        and sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
         *        <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make
         *        the request with an ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        /**
         * <p>
         * The type of the address you request.
         * </p>
         * 
         * @param addressType
         *        The type of the address you request.
         * @see AddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressType
         */
        Builder addressType(String addressType);

        /**
         * <p>
         * The type of the address you request.
         * </p>
         * 
         * @param addressType
         *        The type of the address you request.
         * @see AddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressType
         */
        Builder addressType(AddressType addressType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String siteId;

        private String addressType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSiteAddressRequest model) {
            super(model);
            siteId(model.siteId);
            addressType(model.addressType);
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getAddressType() {
            return addressType;
        }

        public final void setAddressType(String addressType) {
            this.addressType = addressType;
        }

        @Override
        public final Builder addressType(String addressType) {
            this.addressType = addressType;
            return this;
        }

        @Override
        public final Builder addressType(AddressType addressType) {
            this.addressType(addressType == null ? null : addressType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSiteAddressRequest build() {
            return new GetSiteAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
