/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about compute hardware assets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeAttributes.Builder, ComputeAttributes> {
    private static final SdkField<String> HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HostId")
            .getter(getter(ComputeAttributes::hostId)).setter(setter(Builder::hostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostId;

    private ComputeAttributes(BuilderImpl builder) {
        this.hostId = builder.hostId;
    }

    /**
     * <p>
     * The host ID of any Dedicated Hosts on the asset.
     * </p>
     * 
     * @return The host ID of any Dedicated Hosts on the asset.
     */
    public final String hostId() {
        return hostId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeAttributes)) {
            return false;
        }
        ComputeAttributes other = (ComputeAttributes) obj;
        return Objects.equals(hostId(), other.hostId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeAttributes").add("HostId", hostId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostId":
            return Optional.ofNullable(clazz.cast(hostId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeAttributes, T> g) {
        return obj -> g.apply((ComputeAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeAttributes> {
        /**
         * <p>
         * The host ID of any Dedicated Hosts on the asset.
         * </p>
         * 
         * @param hostId
         *        The host ID of any Dedicated Hosts on the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);
    }

    static final class BuilderImpl implements Builder {
        private String hostId;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeAttributes model) {
            hostId(model.hostId);
        }

        public final String getHostId() {
            return hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        @Override
        public ComputeAttributes build() {
            return new ComputeAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
