/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOutpostsResponse extends OutpostsResponse implements
        ToCopyableBuilder<ListOutpostsResponse.Builder, ListOutpostsResponse> {
    private static final SdkField<List<Outpost>> OUTPOSTS_FIELD = SdkField
            .<List<Outpost>> builder(MarshallingType.LIST)
            .memberName("Outposts")
            .getter(getter(ListOutpostsResponse::outposts))
            .setter(setter(Builder::outposts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outposts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Outpost> builder(MarshallingType.SDK_POJO)
                                            .constructor(Outpost::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOutpostsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOSTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Outpost> outposts;

    private final String nextToken;

    private ListOutpostsResponse(BuilderImpl builder) {
        super(builder);
        this.outposts = builder.outposts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outposts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutposts() {
        return outposts != null && !(outposts instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Outposts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutposts} method.
     * </p>
     * 
     * @return The value of the Outposts property for this object.
     */
    public final List<Outpost> outposts() {
        return outposts;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOutposts() ? outposts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutpostsResponse)) {
            return false;
        }
        ListOutpostsResponse other = (ListOutpostsResponse) obj;
        return hasOutposts() == other.hasOutposts() && Objects.equals(outposts(), other.outposts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOutpostsResponse").add("Outposts", hasOutposts() ? outposts() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Outposts":
            return Optional.ofNullable(clazz.cast(outposts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOutpostsResponse, T> g) {
        return obj -> g.apply((ListOutpostsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOutpostsResponse> {
        /**
         * Sets the value of the Outposts property for this object.
         *
         * @param outposts
         *        The new value for the Outposts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outposts(Collection<Outpost> outposts);

        /**
         * Sets the value of the Outposts property for this object.
         *
         * @param outposts
         *        The new value for the Outposts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outposts(Outpost... outposts);

        /**
         * Sets the value of the Outposts property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<Outpost>.Builder} avoiding the need
         * to create one manually via {@link List<Outpost>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Outpost>.Builder#build()} is called immediately and its
         * result is passed to {@link #outposts(List<Outpost>)}.
         * 
         * @param outposts
         *        a consumer that will call methods on {@link List<Outpost>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outposts(List<Outpost>)
         */
        Builder outposts(Consumer<Outpost.Builder>... outposts);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private List<Outpost> outposts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutpostsResponse model) {
            super(model);
            outposts(model.outposts);
            nextToken(model.nextToken);
        }

        public final List<Outpost.Builder> getOutposts() {
            List<Outpost.Builder> result = _outpostListDefinitionCopier.copyToBuilder(this.outposts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutposts(Collection<Outpost.BuilderImpl> outposts) {
            this.outposts = _outpostListDefinitionCopier.copyFromBuilder(outposts);
        }

        @Override
        public final Builder outposts(Collection<Outpost> outposts) {
            this.outposts = _outpostListDefinitionCopier.copy(outposts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outposts(Outpost... outposts) {
            outposts(Arrays.asList(outposts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outposts(Consumer<Outpost.Builder>... outposts) {
            outposts(Stream.of(outposts).map(c -> Outpost.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOutpostsResponse build() {
            return new ListOutpostsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
