/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSiteResponse extends OutpostsResponse implements
        ToCopyableBuilder<GetSiteResponse.Builder, GetSiteResponse> {
    private static final SdkField<Site> SITE_FIELD = SdkField.<Site> builder(MarshallingType.SDK_POJO).memberName("Site")
            .getter(getter(GetSiteResponse::site)).setter(setter(Builder::site)).constructor(Site::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Site").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_FIELD));

    private final Site site;

    private GetSiteResponse(BuilderImpl builder) {
        super(builder);
        this.site = builder.site;
    }

    /**
     * Returns the value of the Site property for this object.
     * 
     * @return The value of the Site property for this object.
     */
    public final Site site() {
        return site;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(site());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSiteResponse)) {
            return false;
        }
        GetSiteResponse other = (GetSiteResponse) obj;
        return Objects.equals(site(), other.site());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSiteResponse").add("Site", site()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Site":
            return Optional.ofNullable(clazz.cast(site()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSiteResponse, T> g) {
        return obj -> g.apply((GetSiteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSiteResponse> {
        /**
         * Sets the value of the Site property for this object.
         *
         * @param site
         *        The new value for the Site property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder site(Site site);

        /**
         * Sets the value of the Site property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Site.Builder} avoiding the need to create
         * one manually via {@link Site#builder()}.
         *
         * When the {@link Consumer} completes, {@link Site.Builder#build()} is called immediately and its result is
         * passed to {@link #site(Site)}.
         * 
         * @param site
         *        a consumer that will call methods on {@link Site.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #site(Site)
         */
        default Builder site(Consumer<Site.Builder> site) {
            return site(Site.builder().applyMutation(site).build());
        }
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private Site site;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSiteResponse model) {
            super(model);
            site(model.site);
        }

        public final Site.Builder getSite() {
            return site != null ? site.toBuilder() : null;
        }

        public final void setSite(Site.BuilderImpl site) {
            this.site = site != null ? site.build() : null;
        }

        @Override
        public final Builder site(Site site) {
            this.site = site;
            return this;
        }

        @Override
        public GetSiteResponse build() {
            return new GetSiteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
