/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCatalogItemsResponse extends OutpostsResponse implements
        ToCopyableBuilder<ListCatalogItemsResponse.Builder, ListCatalogItemsResponse> {
    private static final SdkField<List<CatalogItem>> CATALOG_ITEMS_FIELD = SdkField
            .<List<CatalogItem>> builder(MarshallingType.LIST)
            .memberName("CatalogItems")
            .getter(getter(ListCatalogItemsResponse::catalogItems))
            .setter(setter(Builder::catalogItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CatalogItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CatalogItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCatalogItemsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CatalogItem> catalogItems;

    private final String nextToken;

    private ListCatalogItemsResponse(BuilderImpl builder) {
        super(builder);
        this.catalogItems = builder.catalogItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CatalogItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCatalogItems() {
        return catalogItems != null && !(catalogItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the catalog items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCatalogItems} method.
     * </p>
     * 
     * @return Information about the catalog items.
     */
    public final List<CatalogItem> catalogItems() {
        return catalogItems;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCatalogItems() ? catalogItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCatalogItemsResponse)) {
            return false;
        }
        ListCatalogItemsResponse other = (ListCatalogItemsResponse) obj;
        return hasCatalogItems() == other.hasCatalogItems() && Objects.equals(catalogItems(), other.catalogItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCatalogItemsResponse").add("CatalogItems", hasCatalogItems() ? catalogItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogItems":
            return Optional.ofNullable(clazz.cast(catalogItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCatalogItemsResponse, T> g) {
        return obj -> g.apply((ListCatalogItemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCatalogItemsResponse> {
        /**
         * <p>
         * Information about the catalog items.
         * </p>
         * 
         * @param catalogItems
         *        Information about the catalog items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogItems(Collection<CatalogItem> catalogItems);

        /**
         * <p>
         * Information about the catalog items.
         * </p>
         * 
         * @param catalogItems
         *        Information about the catalog items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogItems(CatalogItem... catalogItems);

        /**
         * <p>
         * Information about the catalog items.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CatalogItem>.Builder} avoiding the
         * need to create one manually via {@link List<CatalogItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CatalogItem>.Builder#build()} is called immediately and its
         * result is passed to {@link #catalogItems(List<CatalogItem>)}.
         * 
         * @param catalogItems
         *        a consumer that will call methods on {@link List<CatalogItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogItems(List<CatalogItem>)
         */
        Builder catalogItems(Consumer<CatalogItem.Builder>... catalogItems);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private List<CatalogItem> catalogItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCatalogItemsResponse model) {
            super(model);
            catalogItems(model.catalogItems);
            nextToken(model.nextToken);
        }

        public final List<CatalogItem.Builder> getCatalogItems() {
            List<CatalogItem.Builder> result = CatalogItemListDefinitionCopier.copyToBuilder(this.catalogItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCatalogItems(Collection<CatalogItem.BuilderImpl> catalogItems) {
            this.catalogItems = CatalogItemListDefinitionCopier.copyFromBuilder(catalogItems);
        }

        @Override
        public final Builder catalogItems(Collection<CatalogItem> catalogItems) {
            this.catalogItems = CatalogItemListDefinitionCopier.copy(catalogItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder catalogItems(CatalogItem... catalogItems) {
            catalogItems(Arrays.asList(catalogItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder catalogItems(Consumer<CatalogItem.Builder>... catalogItems) {
            catalogItems(Stream.of(catalogItems).map(c -> CatalogItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCatalogItemsResponse build() {
            return new ListCatalogItemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
