/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSitesRequest extends OutpostsRequest implements
        ToCopyableBuilder<ListSitesRequest.Builder, ListSitesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSitesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSitesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<List<String>> OPERATING_ADDRESS_COUNTRY_CODE_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OperatingAddressCountryCodeFilter")
            .getter(getter(ListSitesRequest::operatingAddressCountryCodeFilter))
            .setter(setter(Builder::operatingAddressCountryCodeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM)
                    .locationName("OperatingAddressCountryCodeFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPERATING_ADDRESS_STATE_OR_REGION_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OperatingAddressStateOrRegionFilter")
            .getter(getter(ListSitesRequest::operatingAddressStateOrRegionFilter))
            .setter(setter(Builder::operatingAddressStateOrRegionFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM)
                    .locationName("OperatingAddressStateOrRegionFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPERATING_ADDRESS_CITY_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OperatingAddressCityFilter")
            .getter(getter(ListSitesRequest::operatingAddressCityFilter))
            .setter(setter(Builder::operatingAddressCityFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OperatingAddressCityFilter")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, OPERATING_ADDRESS_COUNTRY_CODE_FILTER_FIELD, OPERATING_ADDRESS_STATE_OR_REGION_FILTER_FIELD,
            OPERATING_ADDRESS_CITY_FILTER_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> operatingAddressCountryCodeFilter;

    private final List<String> operatingAddressStateOrRegionFilter;

    private final List<String> operatingAddressCityFilter;

    private ListSitesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.operatingAddressCountryCodeFilter = builder.operatingAddressCountryCodeFilter;
        this.operatingAddressStateOrRegionFilter = builder.operatingAddressStateOrRegionFilter;
        this.operatingAddressCityFilter = builder.operatingAddressCityFilter;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperatingAddressCountryCodeFilter
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasOperatingAddressCountryCodeFilter() {
        return operatingAddressCountryCodeFilter != null && !(operatingAddressCountryCodeFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter for the country code of the Outpost site.
     * </p>
     * <p>
     * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
     * <code>OR</code>, and the request returns all results that match any of the specified values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingAddressCountryCodeFilter}
     * method.
     * </p>
     * 
     * @return A filter for the country code of the Outpost site. </p>
     *         <p>
     *         Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with
     *         an <code>OR</code>, and the request returns all results that match any of the specified values.
     */
    public final List<String> operatingAddressCountryCodeFilter() {
        return operatingAddressCountryCodeFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperatingAddressStateOrRegionFilter
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasOperatingAddressStateOrRegionFilter() {
        return operatingAddressStateOrRegionFilter != null
                && !(operatingAddressStateOrRegionFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter for the state/region of the Outpost site.
     * </p>
     * <p>
     * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
     * <code>OR</code>, and the request returns all results that match any of the specified values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingAddressStateOrRegionFilter}
     * method.
     * </p>
     * 
     * @return A filter for the state/region of the Outpost site. </p>
     *         <p>
     *         Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with
     *         an <code>OR</code>, and the request returns all results that match any of the specified values.
     */
    public final List<String> operatingAddressStateOrRegionFilter() {
        return operatingAddressStateOrRegionFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperatingAddressCityFilter property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOperatingAddressCityFilter() {
        return operatingAddressCityFilter != null && !(operatingAddressCityFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter for the city of the Outpost site.
     * </p>
     * <p>
     * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
     * <code>OR</code>, and the request returns all results that match any of the specified values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingAddressCityFilter} method.
     * </p>
     * 
     * @return A filter for the city of the Outpost site. </p>
     *         <p>
     *         Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with
     *         an <code>OR</code>, and the request returns all results that match any of the specified values.
     */
    public final List<String> operatingAddressCityFilter() {
        return operatingAddressCityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasOperatingAddressCountryCodeFilter() ? operatingAddressCountryCodeFilter() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasOperatingAddressStateOrRegionFilter() ? operatingAddressStateOrRegionFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOperatingAddressCityFilter() ? operatingAddressCityFilter() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSitesRequest)) {
            return false;
        }
        ListSitesRequest other = (ListSitesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasOperatingAddressCountryCodeFilter() == other.hasOperatingAddressCountryCodeFilter()
                && Objects.equals(operatingAddressCountryCodeFilter(), other.operatingAddressCountryCodeFilter())
                && hasOperatingAddressStateOrRegionFilter() == other.hasOperatingAddressStateOrRegionFilter()
                && Objects.equals(operatingAddressStateOrRegionFilter(), other.operatingAddressStateOrRegionFilter())
                && hasOperatingAddressCityFilter() == other.hasOperatingAddressCityFilter()
                && Objects.equals(operatingAddressCityFilter(), other.operatingAddressCityFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListSitesRequest")
                .add("NextToken", nextToken())
                .add("MaxResults", maxResults())
                .add("OperatingAddressCountryCodeFilter",
                        hasOperatingAddressCountryCodeFilter() ? operatingAddressCountryCodeFilter() : null)
                .add("OperatingAddressStateOrRegionFilter",
                        hasOperatingAddressStateOrRegionFilter() ? operatingAddressStateOrRegionFilter() : null)
                .add("OperatingAddressCityFilter", hasOperatingAddressCityFilter() ? operatingAddressCityFilter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "OperatingAddressCountryCodeFilter":
            return Optional.ofNullable(clazz.cast(operatingAddressCountryCodeFilter()));
        case "OperatingAddressStateOrRegionFilter":
            return Optional.ofNullable(clazz.cast(operatingAddressStateOrRegionFilter()));
        case "OperatingAddressCityFilter":
            return Optional.ofNullable(clazz.cast(operatingAddressCityFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSitesRequest, T> g) {
        return obj -> g.apply((ListSitesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSitesRequest> {
        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter for the country code of the Outpost site.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param operatingAddressCountryCodeFilter
         *        A filter for the country code of the Outpost site. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressCountryCodeFilter(Collection<String> operatingAddressCountryCodeFilter);

        /**
         * <p>
         * A filter for the country code of the Outpost site.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param operatingAddressCountryCodeFilter
         *        A filter for the country code of the Outpost site. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressCountryCodeFilter(String... operatingAddressCountryCodeFilter);

        /**
         * <p>
         * A filter for the state/region of the Outpost site.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param operatingAddressStateOrRegionFilter
         *        A filter for the state/region of the Outpost site. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressStateOrRegionFilter(Collection<String> operatingAddressStateOrRegionFilter);

        /**
         * <p>
         * A filter for the state/region of the Outpost site.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param operatingAddressStateOrRegionFilter
         *        A filter for the state/region of the Outpost site. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressStateOrRegionFilter(String... operatingAddressStateOrRegionFilter);

        /**
         * <p>
         * A filter for the city of the Outpost site.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param operatingAddressCityFilter
         *        A filter for the city of the Outpost site. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressCityFilter(Collection<String> operatingAddressCityFilter);

        /**
         * <p>
         * A filter for the city of the Outpost site.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param operatingAddressCityFilter
         *        A filter for the city of the Outpost site. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressCityFilter(String... operatingAddressCityFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<String> operatingAddressCountryCodeFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> operatingAddressStateOrRegionFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> operatingAddressCityFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSitesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            operatingAddressCountryCodeFilter(model.operatingAddressCountryCodeFilter);
            operatingAddressStateOrRegionFilter(model.operatingAddressStateOrRegionFilter);
            operatingAddressCityFilter(model.operatingAddressCityFilter);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getOperatingAddressCountryCodeFilter() {
            if (operatingAddressCountryCodeFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return operatingAddressCountryCodeFilter;
        }

        public final void setOperatingAddressCountryCodeFilter(Collection<String> operatingAddressCountryCodeFilter) {
            this.operatingAddressCountryCodeFilter = CountryCodeListCopier.copy(operatingAddressCountryCodeFilter);
        }

        @Override
        public final Builder operatingAddressCountryCodeFilter(Collection<String> operatingAddressCountryCodeFilter) {
            this.operatingAddressCountryCodeFilter = CountryCodeListCopier.copy(operatingAddressCountryCodeFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingAddressCountryCodeFilter(String... operatingAddressCountryCodeFilter) {
            operatingAddressCountryCodeFilter(Arrays.asList(operatingAddressCountryCodeFilter));
            return this;
        }

        public final Collection<String> getOperatingAddressStateOrRegionFilter() {
            if (operatingAddressStateOrRegionFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return operatingAddressStateOrRegionFilter;
        }

        public final void setOperatingAddressStateOrRegionFilter(Collection<String> operatingAddressStateOrRegionFilter) {
            this.operatingAddressStateOrRegionFilter = StateOrRegionListCopier.copy(operatingAddressStateOrRegionFilter);
        }

        @Override
        public final Builder operatingAddressStateOrRegionFilter(Collection<String> operatingAddressStateOrRegionFilter) {
            this.operatingAddressStateOrRegionFilter = StateOrRegionListCopier.copy(operatingAddressStateOrRegionFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingAddressStateOrRegionFilter(String... operatingAddressStateOrRegionFilter) {
            operatingAddressStateOrRegionFilter(Arrays.asList(operatingAddressStateOrRegionFilter));
            return this;
        }

        public final Collection<String> getOperatingAddressCityFilter() {
            if (operatingAddressCityFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return operatingAddressCityFilter;
        }

        public final void setOperatingAddressCityFilter(Collection<String> operatingAddressCityFilter) {
            this.operatingAddressCityFilter = CityListCopier.copy(operatingAddressCityFilter);
        }

        @Override
        public final Builder operatingAddressCityFilter(Collection<String> operatingAddressCityFilter) {
            this.operatingAddressCityFilter = CityListCopier.copy(operatingAddressCityFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingAddressCityFilter(String... operatingAddressCityFilter) {
            operatingAddressCityFilter(Arrays.asList(operatingAddressCityFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSitesRequest build() {
            return new ListSitesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
