/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSiteRequest extends OutpostsRequest implements ToCopyableBuilder<GetSiteRequest.Builder, GetSiteRequest> {
    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(GetSiteRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SiteId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_ID_FIELD));

    private final String siteId;

    private GetSiteRequest(BuilderImpl builder) {
        super(builder);
        this.siteId = builder.siteId;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * <note>
     * <p>
     * In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and sites
     * throughout the Outposts Query API. To address backwards compatibility, the parameter names <code>OutpostID</code>
     * or <code>SiteID</code> remain in use. Despite the parameter name, you can make the request with an ARN.
     * </p>
     * </note>
     * 
     * @return The ID or the Amazon Resource Name (ARN) of the site. </p> <note>
     *         <p>
     *         In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts
     *         and sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
     *         <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make the
     *         request with an ARN.
     *         </p>
     */
    public final String siteId() {
        return siteId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSiteRequest)) {
            return false;
        }
        GetSiteRequest other = (GetSiteRequest) obj;
        return Objects.equals(siteId(), other.siteId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSiteRequest").add("SiteId", siteId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSiteRequest, T> g) {
        return obj -> g.apply((GetSiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSiteRequest> {
        /**
         * <p>
         * The ID or the Amazon Resource Name (ARN) of the site.
         * </p>
         * <note>
         * <p>
         * In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and
         * sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
         * <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make the
         * request with an ARN.
         * </p>
         * </note>
         * 
         * @param siteId
         *        The ID or the Amazon Resource Name (ARN) of the site. </p> <note>
         *        <p>
         *        In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts
         *        and sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
         *        <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make
         *        the request with an ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String siteId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSiteRequest model) {
            super(model);
            siteId(model.siteId);
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSiteRequest build() {
            return new GetSiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
