/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about hardware assets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetInfo implements SdkPojo, Serializable, ToCopyableBuilder<AssetInfo.Builder, AssetInfo> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetId").getter(getter(AssetInfo::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()).build();

    private static final SdkField<String> RACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RackId")
            .getter(getter(AssetInfo::rackId)).setter(setter(Builder::rackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RackId").build()).build();

    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetType").getter(getter(AssetInfo::assetTypeAsString)).setter(setter(Builder::assetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetType").build()).build();

    private static final SdkField<ComputeAttributes> COMPUTE_ATTRIBUTES_FIELD = SdkField
            .<ComputeAttributes> builder(MarshallingType.SDK_POJO).memberName("ComputeAttributes")
            .getter(getter(AssetInfo::computeAttributes)).setter(setter(Builder::computeAttributes))
            .constructor(ComputeAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, RACK_ID_FIELD,
            ASSET_TYPE_FIELD, COMPUTE_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String rackId;

    private final String assetType;

    private final ComputeAttributes computeAttributes;

    private AssetInfo(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.rackId = builder.rackId;
        this.assetType = builder.assetType;
        this.computeAttributes = builder.computeAttributes;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The rack ID of the asset.
     * </p>
     * 
     * @return The rack ID of the asset.
     */
    public final String rackId() {
        return rackId;
    }

    /**
     * <p>
     * The type of the asset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assetType} will
     * return {@link AssetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #assetTypeAsString}.
     * </p>
     * 
     * @return The type of the asset.
     * @see AssetType
     */
    public final AssetType assetType() {
        return AssetType.fromValue(assetType);
    }

    /**
     * <p>
     * The type of the asset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assetType} will
     * return {@link AssetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #assetTypeAsString}.
     * </p>
     * 
     * @return The type of the asset.
     * @see AssetType
     */
    public final String assetTypeAsString() {
        return assetType;
    }

    /**
     * <p>
     * Information about compute hardware assets.
     * </p>
     * 
     * @return Information about compute hardware assets.
     */
    public final ComputeAttributes computeAttributes() {
        return computeAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(rackId());
        hashCode = 31 * hashCode + Objects.hashCode(assetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computeAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetInfo)) {
            return false;
        }
        AssetInfo other = (AssetInfo) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(rackId(), other.rackId())
                && Objects.equals(assetTypeAsString(), other.assetTypeAsString())
                && Objects.equals(computeAttributes(), other.computeAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetInfo").add("AssetId", assetId()).add("RackId", rackId())
                .add("AssetType", assetTypeAsString()).add("ComputeAttributes", computeAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "RackId":
            return Optional.ofNullable(clazz.cast(rackId()));
        case "AssetType":
            return Optional.ofNullable(clazz.cast(assetTypeAsString()));
        case "ComputeAttributes":
            return Optional.ofNullable(clazz.cast(computeAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetInfo, T> g) {
        return obj -> g.apply((AssetInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetInfo> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The rack ID of the asset.
         * </p>
         * 
         * @param rackId
         *        The rack ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rackId(String rackId);

        /**
         * <p>
         * The type of the asset.
         * </p>
         * 
         * @param assetType
         *        The type of the asset.
         * @see AssetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetType
         */
        Builder assetType(String assetType);

        /**
         * <p>
         * The type of the asset.
         * </p>
         * 
         * @param assetType
         *        The type of the asset.
         * @see AssetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetType
         */
        Builder assetType(AssetType assetType);

        /**
         * <p>
         * Information about compute hardware assets.
         * </p>
         * 
         * @param computeAttributes
         *        Information about compute hardware assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeAttributes(ComputeAttributes computeAttributes);

        /**
         * <p>
         * Information about compute hardware assets.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeAttributes.Builder} avoiding the
         * need to create one manually via {@link ComputeAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComputeAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #computeAttributes(ComputeAttributes)}.
         * 
         * @param computeAttributes
         *        a consumer that will call methods on {@link ComputeAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeAttributes(ComputeAttributes)
         */
        default Builder computeAttributes(Consumer<ComputeAttributes.Builder> computeAttributes) {
            return computeAttributes(ComputeAttributes.builder().applyMutation(computeAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String rackId;

        private String assetType;

        private ComputeAttributes computeAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetInfo model) {
            assetId(model.assetId);
            rackId(model.rackId);
            assetType(model.assetType);
            computeAttributes(model.computeAttributes);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getRackId() {
            return rackId;
        }

        public final void setRackId(String rackId) {
            this.rackId = rackId;
        }

        @Override
        public final Builder rackId(String rackId) {
            this.rackId = rackId;
            return this;
        }

        public final String getAssetType() {
            return assetType;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        @Override
        public final Builder assetType(AssetType assetType) {
            this.assetType(assetType == null ? null : assetType.toString());
            return this;
        }

        public final ComputeAttributes.Builder getComputeAttributes() {
            return computeAttributes != null ? computeAttributes.toBuilder() : null;
        }

        public final void setComputeAttributes(ComputeAttributes.BuilderImpl computeAttributes) {
            this.computeAttributes = computeAttributes != null ? computeAttributes.build() : null;
        }

        @Override
        public final Builder computeAttributes(ComputeAttributes computeAttributes) {
            this.computeAttributes = computeAttributes;
            return this;
        }

        @Override
        public AssetInfo build() {
            return new AssetInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
