/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of line items in your order.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrderSummary implements SdkPojo, Serializable, ToCopyableBuilder<OrderSummary.Builder, OrderSummary> {
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(OrderSummary::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()).build();

    private static final SdkField<String> ORDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrderId").getter(getter(OrderSummary::orderId)).setter(setter(Builder::orderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()).build();

    private static final SdkField<String> ORDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrderType").getter(getter(OrderSummary::orderTypeAsString)).setter(setter(Builder::orderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OrderSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, Integer>> LINE_ITEM_COUNTS_BY_STATUS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("LineItemCountsByStatus")
            .getter(getter(OrderSummary::lineItemCountsByStatusAsStrings))
            .setter(setter(Builder::lineItemCountsByStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemCountsByStatus").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> ORDER_SUBMISSION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OrderSubmissionDate").getter(getter(OrderSummary::orderSubmissionDate))
            .setter(setter(Builder::orderSubmissionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderSubmissionDate").build())
            .build();

    private static final SdkField<Instant> ORDER_FULFILLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OrderFulfilledDate").getter(getter(OrderSummary::orderFulfilledDate))
            .setter(setter(Builder::orderFulfilledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderFulfilledDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ID_FIELD,
            ORDER_ID_FIELD, ORDER_TYPE_FIELD, STATUS_FIELD, LINE_ITEM_COUNTS_BY_STATUS_FIELD, ORDER_SUBMISSION_DATE_FIELD,
            ORDER_FULFILLED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outpostId;

    private final String orderId;

    private final String orderType;

    private final String status;

    private final Map<String, Integer> lineItemCountsByStatus;

    private final Instant orderSubmissionDate;

    private final Instant orderFulfilledDate;

    private OrderSummary(BuilderImpl builder) {
        this.outpostId = builder.outpostId;
        this.orderId = builder.orderId;
        this.orderType = builder.orderType;
        this.status = builder.status;
        this.lineItemCountsByStatus = builder.lineItemCountsByStatus;
        this.orderSubmissionDate = builder.orderSubmissionDate;
        this.orderFulfilledDate = builder.orderFulfilledDate;
    }

    /**
     * <p>
     * The ID of the Outpost.
     * </p>
     * 
     * @return The ID of the Outpost.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * <p>
     * The ID of the order.
     * </p>
     * 
     * @return The ID of the order.
     */
    public final String orderId() {
        return orderId;
    }

    /**
     * <p>
     * The type of order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderType} will
     * return {@link OrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderTypeAsString}.
     * </p>
     * 
     * @return The type of order.
     * @see OrderType
     */
    public final OrderType orderType() {
        return OrderType.fromValue(orderType);
    }

    /**
     * <p>
     * The type of order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderType} will
     * return {@link OrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderTypeAsString}.
     * </p>
     * 
     * @return The type of order.
     * @see OrderType
     */
    public final String orderTypeAsString() {
        return orderType;
    }

    /**
     * <p>
     * The status of the order.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PREPARING</code> - Order is received and is being prepared.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information, see the
     * <code>LineItem</code> status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - Order is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> - Order is cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - Customer should contact support.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>, <code>PROCESSING</code>,
     * <code>INSTALLING</code>, and <code>FULFILLED</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the order.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PREPARING</code> - Order is received and is being prepared.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information, see
     *         the <code>LineItem</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - Order is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> - Order is cancelled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - Customer should contact support.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
     *         <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>.
     *         </p>
     * @see OrderStatus
     */
    public final OrderStatus status() {
        return OrderStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the order.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PREPARING</code> - Order is received and is being prepared.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information, see the
     * <code>LineItem</code> status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - Order is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> - Order is cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - Customer should contact support.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>, <code>PROCESSING</code>,
     * <code>INSTALLING</code>, and <code>FULFILLED</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the order.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PREPARING</code> - Order is received and is being prepared.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information, see
     *         the <code>LineItem</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - Order is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> - Order is cancelled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - Customer should contact support.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
     *         <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>.
     *         </p>
     * @see OrderStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status of all line items in the order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineItemCountsByStatus} method.
     * </p>
     * 
     * @return The status of all line items in the order.
     */
    public final Map<LineItemStatus, Integer> lineItemCountsByStatus() {
        return LineItemStatusCountsCopier.copyStringToEnum(lineItemCountsByStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the LineItemCountsByStatus property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLineItemCountsByStatus() {
        return lineItemCountsByStatus != null && !(lineItemCountsByStatus instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The status of all line items in the order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineItemCountsByStatus} method.
     * </p>
     * 
     * @return The status of all line items in the order.
     */
    public final Map<String, Integer> lineItemCountsByStatusAsStrings() {
        return lineItemCountsByStatus;
    }

    /**
     * <p>
     * Submission date for the order.
     * </p>
     * 
     * @return Submission date for the order.
     */
    public final Instant orderSubmissionDate() {
        return orderSubmissionDate;
    }

    /**
     * <p>
     * Fulfilment date for the order.
     * </p>
     * 
     * @return Fulfilment date for the order.
     */
    public final Instant orderFulfilledDate() {
        return orderFulfilledDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(orderId());
        hashCode = 31 * hashCode + Objects.hashCode(orderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLineItemCountsByStatus() ? lineItemCountsByStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orderSubmissionDate());
        hashCode = 31 * hashCode + Objects.hashCode(orderFulfilledDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderSummary)) {
            return false;
        }
        OrderSummary other = (OrderSummary) obj;
        return Objects.equals(outpostId(), other.outpostId()) && Objects.equals(orderId(), other.orderId())
                && Objects.equals(orderTypeAsString(), other.orderTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasLineItemCountsByStatus() == other.hasLineItemCountsByStatus()
                && Objects.equals(lineItemCountsByStatusAsStrings(), other.lineItemCountsByStatusAsStrings())
                && Objects.equals(orderSubmissionDate(), other.orderSubmissionDate())
                && Objects.equals(orderFulfilledDate(), other.orderFulfilledDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrderSummary").add("OutpostId", outpostId()).add("OrderId", orderId())
                .add("OrderType", orderTypeAsString()).add("Status", statusAsString())
                .add("LineItemCountsByStatus", hasLineItemCountsByStatus() ? lineItemCountsByStatusAsStrings() : null)
                .add("OrderSubmissionDate", orderSubmissionDate()).add("OrderFulfilledDate", orderFulfilledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "OrderId":
            return Optional.ofNullable(clazz.cast(orderId()));
        case "OrderType":
            return Optional.ofNullable(clazz.cast(orderTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LineItemCountsByStatus":
            return Optional.ofNullable(clazz.cast(lineItemCountsByStatusAsStrings()));
        case "OrderSubmissionDate":
            return Optional.ofNullable(clazz.cast(orderSubmissionDate()));
        case "OrderFulfilledDate":
            return Optional.ofNullable(clazz.cast(orderFulfilledDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrderSummary, T> g) {
        return obj -> g.apply((OrderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrderSummary> {
        /**
         * <p>
         * The ID of the Outpost.
         * </p>
         * 
         * @param outpostId
         *        The ID of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * <p>
         * The ID of the order.
         * </p>
         * 
         * @param orderId
         *        The ID of the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderId(String orderId);

        /**
         * <p>
         * The type of order.
         * </p>
         * 
         * @param orderType
         *        The type of order.
         * @see OrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderType
         */
        Builder orderType(String orderType);

        /**
         * <p>
         * The type of order.
         * </p>
         * 
         * @param orderType
         *        The type of order.
         * @see OrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderType
         */
        Builder orderType(OrderType orderType);

        /**
         * <p>
         * The status of the order.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PREPARING</code> - Order is received and is being prepared.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information, see the
         * <code>LineItem</code> status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - Order is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> - Order is cancelled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - Customer should contact support.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>, <code>PROCESSING</code>,
         * <code>INSTALLING</code>, and <code>FULFILLED</code>.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the order.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PREPARING</code> - Order is received and is being prepared.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information,
         *        see the <code>LineItem</code> status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - Order is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> - Order is cancelled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - Customer should contact support.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
         *        <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>.
         *        </p>
         * @see OrderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the order.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PREPARING</code> - Order is received and is being prepared.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information, see the
         * <code>LineItem</code> status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - Order is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> - Order is cancelled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - Customer should contact support.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>, <code>PROCESSING</code>,
         * <code>INSTALLING</code>, and <code>FULFILLED</code>.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the order.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PREPARING</code> - Order is received and is being prepared.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information,
         *        see the <code>LineItem</code> status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - Order is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> - Order is cancelled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - Customer should contact support.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>,
         *        <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>.
         *        </p>
         * @see OrderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderStatus
         */
        Builder status(OrderStatus status);

        /**
         * <p>
         * The status of all line items in the order.
         * </p>
         * 
         * @param lineItemCountsByStatus
         *        The status of all line items in the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemCountsByStatusWithStrings(Map<String, Integer> lineItemCountsByStatus);

        /**
         * <p>
         * The status of all line items in the order.
         * </p>
         * 
         * @param lineItemCountsByStatus
         *        The status of all line items in the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemCountsByStatus(Map<LineItemStatus, Integer> lineItemCountsByStatus);

        /**
         * <p>
         * Submission date for the order.
         * </p>
         * 
         * @param orderSubmissionDate
         *        Submission date for the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderSubmissionDate(Instant orderSubmissionDate);

        /**
         * <p>
         * Fulfilment date for the order.
         * </p>
         * 
         * @param orderFulfilledDate
         *        Fulfilment date for the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderFulfilledDate(Instant orderFulfilledDate);
    }

    static final class BuilderImpl implements Builder {
        private String outpostId;

        private String orderId;

        private String orderType;

        private String status;

        private Map<String, Integer> lineItemCountsByStatus = DefaultSdkAutoConstructMap.getInstance();

        private Instant orderSubmissionDate;

        private Instant orderFulfilledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderSummary model) {
            outpostId(model.outpostId);
            orderId(model.orderId);
            orderType(model.orderType);
            status(model.status);
            lineItemCountsByStatusWithStrings(model.lineItemCountsByStatus);
            orderSubmissionDate(model.orderSubmissionDate);
            orderFulfilledDate(model.orderFulfilledDate);
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOrderId() {
            return orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final String getOrderType() {
            return orderType;
        }

        public final void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        @Override
        public final Builder orderType(String orderType) {
            this.orderType = orderType;
            return this;
        }

        @Override
        public final Builder orderType(OrderType orderType) {
            this.orderType(orderType == null ? null : orderType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, Integer> getLineItemCountsByStatus() {
            if (lineItemCountsByStatus instanceof SdkAutoConstructMap) {
                return null;
            }
            return lineItemCountsByStatus;
        }

        public final void setLineItemCountsByStatus(Map<String, Integer> lineItemCountsByStatus) {
            this.lineItemCountsByStatus = LineItemStatusCountsCopier.copy(lineItemCountsByStatus);
        }

        @Override
        public final Builder lineItemCountsByStatusWithStrings(Map<String, Integer> lineItemCountsByStatus) {
            this.lineItemCountsByStatus = LineItemStatusCountsCopier.copy(lineItemCountsByStatus);
            return this;
        }

        @Override
        public final Builder lineItemCountsByStatus(Map<LineItemStatus, Integer> lineItemCountsByStatus) {
            this.lineItemCountsByStatus = LineItemStatusCountsCopier.copyEnumToString(lineItemCountsByStatus);
            return this;
        }

        public final Instant getOrderSubmissionDate() {
            return orderSubmissionDate;
        }

        public final void setOrderSubmissionDate(Instant orderSubmissionDate) {
            this.orderSubmissionDate = orderSubmissionDate;
        }

        @Override
        public final Builder orderSubmissionDate(Instant orderSubmissionDate) {
            this.orderSubmissionDate = orderSubmissionDate;
            return this;
        }

        public final Instant getOrderFulfilledDate() {
            return orderFulfilledDate;
        }

        public final void setOrderFulfilledDate(Instant orderFulfilledDate) {
            this.orderFulfilledDate = orderFulfilledDate;
        }

        @Override
        public final Builder orderFulfilledDate(Instant orderFulfilledDate) {
            this.orderFulfilledDate = orderFulfilledDate;
            return this;
        }

        @Override
        public OrderSummary build() {
            return new OrderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
