/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSiteAddressRequest extends OutpostsRequest implements
        ToCopyableBuilder<UpdateSiteAddressRequest.Builder, UpdateSiteAddressRequest> {
    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(UpdateSiteAddressRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SiteId").build()).build();

    private static final SdkField<String> ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressType").getter(getter(UpdateSiteAddressRequest::addressTypeAsString))
            .setter(setter(Builder::addressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressType").build()).build();

    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(UpdateSiteAddressRequest::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_ID_FIELD,
            ADDRESS_TYPE_FIELD, ADDRESS_FIELD));

    private final String siteId;

    private final String addressType;

    private final Address address;

    private UpdateSiteAddressRequest(BuilderImpl builder) {
        super(builder);
        this.siteId = builder.siteId;
        this.addressType = builder.addressType;
        this.address = builder.address;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * 
     * @return The ID or the Amazon Resource Name (ARN) of the site.
     */
    public final String siteId() {
        return siteId;
    }

    /**
     * <p>
     * The type of the address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressType} will
     * return {@link AddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressTypeAsString}.
     * </p>
     * 
     * @return The type of the address.
     * @see AddressType
     */
    public final AddressType addressType() {
        return AddressType.fromValue(addressType);
    }

    /**
     * <p>
     * The type of the address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressType} will
     * return {@link AddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressTypeAsString}.
     * </p>
     * 
     * @return The type of the address.
     * @see AddressType
     */
    public final String addressTypeAsString() {
        return addressType;
    }

    /**
     * <p>
     * The address for the site.
     * </p>
     * 
     * @return The address for the site.
     */
    public final Address address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        hashCode = 31 * hashCode + Objects.hashCode(addressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSiteAddressRequest)) {
            return false;
        }
        UpdateSiteAddressRequest other = (UpdateSiteAddressRequest) obj;
        return Objects.equals(siteId(), other.siteId()) && Objects.equals(addressTypeAsString(), other.addressTypeAsString())
                && Objects.equals(address(), other.address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSiteAddressRequest").add("SiteId", siteId()).add("AddressType", addressTypeAsString())
                .add("Address", address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        case "AddressType":
            return Optional.ofNullable(clazz.cast(addressTypeAsString()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSiteAddressRequest, T> g) {
        return obj -> g.apply((UpdateSiteAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSiteAddressRequest> {
        /**
         * <p>
         * The ID or the Amazon Resource Name (ARN) of the site.
         * </p>
         * 
         * @param siteId
         *        The ID or the Amazon Resource Name (ARN) of the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        /**
         * <p>
         * The type of the address.
         * </p>
         * 
         * @param addressType
         *        The type of the address.
         * @see AddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressType
         */
        Builder addressType(String addressType);

        /**
         * <p>
         * The type of the address.
         * </p>
         * 
         * @param addressType
         *        The type of the address.
         * @see AddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressType
         */
        Builder addressType(AddressType addressType);

        /**
         * <p>
         * The address for the site.
         * </p>
         * 
         * @param address
         *        The address for the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * <p>
         * The address for the site.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String siteId;

        private String addressType;

        private Address address;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSiteAddressRequest model) {
            super(model);
            siteId(model.siteId);
            addressType(model.addressType);
            address(model.address);
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getAddressType() {
            return addressType;
        }

        public final void setAddressType(String addressType) {
            this.addressType = addressType;
        }

        @Override
        public final Builder addressType(String addressType) {
            this.addressType = addressType;
            return this;
        }

        @Override
        public final Builder addressType(AddressType addressType) {
            this.addressType(addressType == null ? null : addressType.toString());
            return this;
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSiteAddressRequest build() {
            return new UpdateSiteAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
