/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSiteRackPhysicalPropertiesRequest extends OutpostsRequest implements
        ToCopyableBuilder<UpdateSiteRackPhysicalPropertiesRequest.Builder, UpdateSiteRackPhysicalPropertiesRequest> {
    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(UpdateSiteRackPhysicalPropertiesRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SiteId").build()).build();

    private static final SdkField<String> POWER_DRAW_KVA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PowerDrawKva").getter(getter(UpdateSiteRackPhysicalPropertiesRequest::powerDrawKvaAsString))
            .setter(setter(Builder::powerDrawKva))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerDrawKva").build()).build();

    private static final SdkField<String> POWER_PHASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PowerPhase").getter(getter(UpdateSiteRackPhysicalPropertiesRequest::powerPhaseAsString))
            .setter(setter(Builder::powerPhase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerPhase").build()).build();

    private static final SdkField<String> POWER_CONNECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PowerConnector").getter(getter(UpdateSiteRackPhysicalPropertiesRequest::powerConnectorAsString))
            .setter(setter(Builder::powerConnector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerConnector").build()).build();

    private static final SdkField<String> POWER_FEED_DROP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PowerFeedDrop").getter(getter(UpdateSiteRackPhysicalPropertiesRequest::powerFeedDropAsString))
            .setter(setter(Builder::powerFeedDrop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerFeedDrop").build()).build();

    private static final SdkField<String> UPLINK_GBPS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UplinkGbps").getter(getter(UpdateSiteRackPhysicalPropertiesRequest::uplinkGbpsAsString))
            .setter(setter(Builder::uplinkGbps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UplinkGbps").build()).build();

    private static final SdkField<String> UPLINK_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UplinkCount").getter(getter(UpdateSiteRackPhysicalPropertiesRequest::uplinkCountAsString))
            .setter(setter(Builder::uplinkCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UplinkCount").build()).build();

    private static final SdkField<String> FIBER_OPTIC_CABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FiberOpticCableType")
            .getter(getter(UpdateSiteRackPhysicalPropertiesRequest::fiberOpticCableTypeAsString))
            .setter(setter(Builder::fiberOpticCableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FiberOpticCableType").build())
            .build();

    private static final SdkField<String> OPTICAL_STANDARD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpticalStandard").getter(getter(UpdateSiteRackPhysicalPropertiesRequest::opticalStandardAsString))
            .setter(setter(Builder::opticalStandard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpticalStandard").build()).build();

    private static final SdkField<String> MAXIMUM_SUPPORTED_WEIGHT_LBS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaximumSupportedWeightLbs")
            .getter(getter(UpdateSiteRackPhysicalPropertiesRequest::maximumSupportedWeightLbsAsString))
            .setter(setter(Builder::maximumSupportedWeightLbs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumSupportedWeightLbs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_ID_FIELD,
            POWER_DRAW_KVA_FIELD, POWER_PHASE_FIELD, POWER_CONNECTOR_FIELD, POWER_FEED_DROP_FIELD, UPLINK_GBPS_FIELD,
            UPLINK_COUNT_FIELD, FIBER_OPTIC_CABLE_TYPE_FIELD, OPTICAL_STANDARD_FIELD, MAXIMUM_SUPPORTED_WEIGHT_LBS_FIELD));

    private final String siteId;

    private final String powerDrawKva;

    private final String powerPhase;

    private final String powerConnector;

    private final String powerFeedDrop;

    private final String uplinkGbps;

    private final String uplinkCount;

    private final String fiberOpticCableType;

    private final String opticalStandard;

    private final String maximumSupportedWeightLbs;

    private UpdateSiteRackPhysicalPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.siteId = builder.siteId;
        this.powerDrawKva = builder.powerDrawKva;
        this.powerPhase = builder.powerPhase;
        this.powerConnector = builder.powerConnector;
        this.powerFeedDrop = builder.powerFeedDrop;
        this.uplinkGbps = builder.uplinkGbps;
        this.uplinkCount = builder.uplinkCount;
        this.fiberOpticCableType = builder.fiberOpticCableType;
        this.opticalStandard = builder.opticalStandard;
        this.maximumSupportedWeightLbs = builder.maximumSupportedWeightLbs;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * 
     * @return The ID or the Amazon Resource Name (ARN) of the site.
     */
    public final String siteId() {
        return siteId;
    }

    /**
     * <p>
     * Specify in kVA the power draw available at the hardware placement position for the rack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerDrawKva} will
     * return {@link PowerDrawKva#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerDrawKvaAsString}.
     * </p>
     * 
     * @return Specify in kVA the power draw available at the hardware placement position for the rack.
     * @see PowerDrawKva
     */
    public final PowerDrawKva powerDrawKva() {
        return PowerDrawKva.fromValue(powerDrawKva);
    }

    /**
     * <p>
     * Specify in kVA the power draw available at the hardware placement position for the rack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerDrawKva} will
     * return {@link PowerDrawKva#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerDrawKvaAsString}.
     * </p>
     * 
     * @return Specify in kVA the power draw available at the hardware placement position for the rack.
     * @see PowerDrawKva
     */
    public final String powerDrawKvaAsString() {
        return powerDrawKva;
    }

    /**
     * <p>
     * Specify the power option that you can provide for hardware.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz
     * </p>
     * </li>
     * <li>
     * <p>
     * Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerPhase} will
     * return {@link PowerPhase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerPhaseAsString}.
     * </p>
     * 
     * @return Specify the power option that you can provide for hardware. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz
     *         </p>
     *         </li>
     * @see PowerPhase
     */
    public final PowerPhase powerPhase() {
        return PowerPhase.fromValue(powerPhase);
    }

    /**
     * <p>
     * Specify the power option that you can provide for hardware.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz
     * </p>
     * </li>
     * <li>
     * <p>
     * Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerPhase} will
     * return {@link PowerPhase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerPhaseAsString}.
     * </p>
     * 
     * @return Specify the power option that you can provide for hardware. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz
     *         </p>
     *         </li>
     * @see PowerPhase
     */
    public final String powerPhaseAsString() {
        return powerPhase;
    }

    /**
     * <p>
     * Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note
     * the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Single-phase AC feed
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>L6-30P</b> – (common in US); 30A; single phase
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Three-phase AC feed
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerConnector}
     * will return {@link PowerConnector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #powerConnectorAsString}.
     * </p>
     * 
     * @return Specify the power connector that Amazon Web Services should plan to provide for connections to the
     *         hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Single-phase AC feed
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>L6-30P</b> – (common in US); 30A; single phase
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Three-phase AC feed
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see PowerConnector
     */
    public final PowerConnector powerConnector() {
        return PowerConnector.fromValue(powerConnector);
    }

    /**
     * <p>
     * Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware. Note
     * the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Single-phase AC feed
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>L6-30P</b> – (common in US); 30A; single phase
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Three-phase AC feed
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerConnector}
     * will return {@link PowerConnector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #powerConnectorAsString}.
     * </p>
     * 
     * @return Specify the power connector that Amazon Web Services should plan to provide for connections to the
     *         hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Single-phase AC feed
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>L6-30P</b> – (common in US); 30A; single phase
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Three-phase AC feed
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see PowerConnector
     */
    public final String powerConnectorAsString() {
        return powerConnector;
    }

    /**
     * <p>
     * Specify whether the power feed comes above or below the rack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerFeedDrop}
     * will return {@link PowerFeedDrop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerFeedDropAsString}.
     * </p>
     * 
     * @return Specify whether the power feed comes above or below the rack.
     * @see PowerFeedDrop
     */
    public final PowerFeedDrop powerFeedDrop() {
        return PowerFeedDrop.fromValue(powerFeedDrop);
    }

    /**
     * <p>
     * Specify whether the power feed comes above or below the rack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerFeedDrop}
     * will return {@link PowerFeedDrop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerFeedDropAsString}.
     * </p>
     * 
     * @return Specify whether the power feed comes above or below the rack.
     * @see PowerFeedDrop
     */
    public final String powerFeedDropAsString() {
        return powerFeedDrop;
    }

    /**
     * <p>
     * Specify the uplink speed the rack should support for the connection to the Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uplinkGbps} will
     * return {@link UplinkGbps#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uplinkGbpsAsString}.
     * </p>
     * 
     * @return Specify the uplink speed the rack should support for the connection to the Region.
     * @see UplinkGbps
     */
    public final UplinkGbps uplinkGbps() {
        return UplinkGbps.fromValue(uplinkGbps);
    }

    /**
     * <p>
     * Specify the uplink speed the rack should support for the connection to the Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uplinkGbps} will
     * return {@link UplinkGbps#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uplinkGbpsAsString}.
     * </p>
     * 
     * @return Specify the uplink speed the rack should support for the connection to the Region.
     * @see UplinkGbps
     */
    public final String uplinkGbpsAsString() {
        return uplinkGbps;
    }

    /**
     * <p>
     * Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost
     * network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network
     * device that you intend to use to connect the rack to your network. Note the correlation between
     * <code>UplinkGbps</code> and <code>UplinkCount</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 1Gbps - Uplinks available: 1, 2, 4, 6, 8
     * </p>
     * </li>
     * <li>
     * <p>
     * 10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16
     * </p>
     * </li>
     * <li>
     * <p>
     * 40 and 100 Gbps- Uplinks available: 1, 2, 4
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uplinkCount} will
     * return {@link UplinkCount#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uplinkCountAsString}.
     * </p>
     * 
     * @return Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the
     *         Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each
     *         Outpost network device that you intend to use to connect the rack to your network. Note the correlation
     *         between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         1Gbps - Uplinks available: 1, 2, 4, 6, 8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         40 and 100 Gbps- Uplinks available: 1, 2, 4
     *         </p>
     *         </li>
     * @see UplinkCount
     */
    public final UplinkCount uplinkCount() {
        return UplinkCount.fromValue(uplinkCount);
    }

    /**
     * <p>
     * Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost
     * network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network
     * device that you intend to use to connect the rack to your network. Note the correlation between
     * <code>UplinkGbps</code> and <code>UplinkCount</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 1Gbps - Uplinks available: 1, 2, 4, 6, 8
     * </p>
     * </li>
     * <li>
     * <p>
     * 10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16
     * </p>
     * </li>
     * <li>
     * <p>
     * 40 and 100 Gbps- Uplinks available: 1, 2, 4
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uplinkCount} will
     * return {@link UplinkCount#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uplinkCountAsString}.
     * </p>
     * 
     * @return Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the
     *         Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each
     *         Outpost network device that you intend to use to connect the rack to your network. Note the correlation
     *         between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         1Gbps - Uplinks available: 1, 2, 4, 6, 8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         40 and 100 Gbps- Uplinks available: 1, 2, 4
     *         </p>
     *         </li>
     * @see UplinkCount
     */
    public final String uplinkCountAsString() {
        return uplinkCount;
    }

    /**
     * <p>
     * Specify the type of fiber that you will use to attach the Outpost to your network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fiberOpticCableType} will return {@link FiberOpticCableType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fiberOpticCableTypeAsString}.
     * </p>
     * 
     * @return Specify the type of fiber that you will use to attach the Outpost to your network.
     * @see FiberOpticCableType
     */
    public final FiberOpticCableType fiberOpticCableType() {
        return FiberOpticCableType.fromValue(fiberOpticCableType);
    }

    /**
     * <p>
     * Specify the type of fiber that you will use to attach the Outpost to your network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fiberOpticCableType} will return {@link FiberOpticCableType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fiberOpticCableTypeAsString}.
     * </p>
     * 
     * @return Specify the type of fiber that you will use to attach the Outpost to your network.
     * @see FiberOpticCableType
     */
    public final String fiberOpticCableTypeAsString() {
        return fiberOpticCableType;
    }

    /**
     * <p>
     * Specify the type of optical standard that you will use to attach the Outpost to your network. This field is
     * dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking
     * requirements for racks, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
     * >Network</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_1000BASE_LX</code>: 1000Base-LX
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_1000BASE_SX</code> : 1000Base-SX
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opticalStandard}
     * will return {@link OpticalStandard#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opticalStandardAsString}.
     * </p>
     * 
     * @return Specify the type of optical standard that you will use to attach the Outpost to your network. This field
     *         is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about
     *         networking requirements for racks, see <a href=
     *         "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
     *         >Network</a> in the Amazon Web Services Outposts User Guide. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_1000BASE_LX</code>: 1000Base-LX
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_1000BASE_SX</code> : 1000Base-SX
     *         </p>
     *         </li>
     * @see OpticalStandard
     */
    public final OpticalStandard opticalStandard() {
        return OpticalStandard.fromValue(opticalStandard);
    }

    /**
     * <p>
     * Specify the type of optical standard that you will use to attach the Outpost to your network. This field is
     * dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking
     * requirements for racks, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
     * >Network</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_1000BASE_LX</code>: 1000Base-LX
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIC_1000BASE_SX</code> : 1000Base-SX
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opticalStandard}
     * will return {@link OpticalStandard#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opticalStandardAsString}.
     * </p>
     * 
     * @return Specify the type of optical standard that you will use to attach the Outpost to your network. This field
     *         is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about
     *         networking requirements for racks, see <a href=
     *         "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
     *         >Network</a> in the Amazon Web Services Outposts User Guide. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_1000BASE_LX</code>: 1000Base-LX
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIC_1000BASE_SX</code> : 1000Base-SX
     *         </p>
     *         </li>
     * @see OpticalStandard
     */
    public final String opticalStandardAsString() {
        return opticalStandard;
    }

    /**
     * <p>
     * Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumSupportedWeightLbs} will return {@link MaximumSupportedWeightLbs#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumSupportedWeightLbsAsString}.
     * </p>
     * 
     * @return Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs.
     * @see MaximumSupportedWeightLbs
     */
    public final MaximumSupportedWeightLbs maximumSupportedWeightLbs() {
        return MaximumSupportedWeightLbs.fromValue(maximumSupportedWeightLbs);
    }

    /**
     * <p>
     * Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumSupportedWeightLbs} will return {@link MaximumSupportedWeightLbs#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumSupportedWeightLbsAsString}.
     * </p>
     * 
     * @return Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs.
     * @see MaximumSupportedWeightLbs
     */
    public final String maximumSupportedWeightLbsAsString() {
        return maximumSupportedWeightLbs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        hashCode = 31 * hashCode + Objects.hashCode(powerDrawKvaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(powerPhaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(powerConnectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(powerFeedDropAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkGbpsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkCountAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fiberOpticCableTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(opticalStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumSupportedWeightLbsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSiteRackPhysicalPropertiesRequest)) {
            return false;
        }
        UpdateSiteRackPhysicalPropertiesRequest other = (UpdateSiteRackPhysicalPropertiesRequest) obj;
        return Objects.equals(siteId(), other.siteId()) && Objects.equals(powerDrawKvaAsString(), other.powerDrawKvaAsString())
                && Objects.equals(powerPhaseAsString(), other.powerPhaseAsString())
                && Objects.equals(powerConnectorAsString(), other.powerConnectorAsString())
                && Objects.equals(powerFeedDropAsString(), other.powerFeedDropAsString())
                && Objects.equals(uplinkGbpsAsString(), other.uplinkGbpsAsString())
                && Objects.equals(uplinkCountAsString(), other.uplinkCountAsString())
                && Objects.equals(fiberOpticCableTypeAsString(), other.fiberOpticCableTypeAsString())
                && Objects.equals(opticalStandardAsString(), other.opticalStandardAsString())
                && Objects.equals(maximumSupportedWeightLbsAsString(), other.maximumSupportedWeightLbsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSiteRackPhysicalPropertiesRequest").add("SiteId", siteId())
                .add("PowerDrawKva", powerDrawKvaAsString()).add("PowerPhase", powerPhaseAsString())
                .add("PowerConnector", powerConnectorAsString()).add("PowerFeedDrop", powerFeedDropAsString())
                .add("UplinkGbps", uplinkGbpsAsString()).add("UplinkCount", uplinkCountAsString())
                .add("FiberOpticCableType", fiberOpticCableTypeAsString()).add("OpticalStandard", opticalStandardAsString())
                .add("MaximumSupportedWeightLbs", maximumSupportedWeightLbsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        case "PowerDrawKva":
            return Optional.ofNullable(clazz.cast(powerDrawKvaAsString()));
        case "PowerPhase":
            return Optional.ofNullable(clazz.cast(powerPhaseAsString()));
        case "PowerConnector":
            return Optional.ofNullable(clazz.cast(powerConnectorAsString()));
        case "PowerFeedDrop":
            return Optional.ofNullable(clazz.cast(powerFeedDropAsString()));
        case "UplinkGbps":
            return Optional.ofNullable(clazz.cast(uplinkGbpsAsString()));
        case "UplinkCount":
            return Optional.ofNullable(clazz.cast(uplinkCountAsString()));
        case "FiberOpticCableType":
            return Optional.ofNullable(clazz.cast(fiberOpticCableTypeAsString()));
        case "OpticalStandard":
            return Optional.ofNullable(clazz.cast(opticalStandardAsString()));
        case "MaximumSupportedWeightLbs":
            return Optional.ofNullable(clazz.cast(maximumSupportedWeightLbsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSiteRackPhysicalPropertiesRequest, T> g) {
        return obj -> g.apply((UpdateSiteRackPhysicalPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSiteRackPhysicalPropertiesRequest> {
        /**
         * <p>
         * The ID or the Amazon Resource Name (ARN) of the site.
         * </p>
         * 
         * @param siteId
         *        The ID or the Amazon Resource Name (ARN) of the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        /**
         * <p>
         * Specify in kVA the power draw available at the hardware placement position for the rack.
         * </p>
         * 
         * @param powerDrawKva
         *        Specify in kVA the power draw available at the hardware placement position for the rack.
         * @see PowerDrawKva
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerDrawKva
         */
        Builder powerDrawKva(String powerDrawKva);

        /**
         * <p>
         * Specify in kVA the power draw available at the hardware placement position for the rack.
         * </p>
         * 
         * @param powerDrawKva
         *        Specify in kVA the power draw available at the hardware placement position for the rack.
         * @see PowerDrawKva
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerDrawKva
         */
        Builder powerDrawKva(PowerDrawKva powerDrawKva);

        /**
         * <p>
         * Specify the power option that you can provide for hardware.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz
         * </p>
         * </li>
         * <li>
         * <p>
         * Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz
         * </p>
         * </li>
         * </ul>
         * 
         * @param powerPhase
         *        Specify the power option that you can provide for hardware. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz
         *        </p>
         *        </li>
         * @see PowerPhase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerPhase
         */
        Builder powerPhase(String powerPhase);

        /**
         * <p>
         * Specify the power option that you can provide for hardware.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz
         * </p>
         * </li>
         * <li>
         * <p>
         * Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz
         * </p>
         * </li>
         * </ul>
         * 
         * @param powerPhase
         *        Specify the power option that you can provide for hardware. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz
         *        </p>
         *        </li>
         * @see PowerPhase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerPhase
         */
        Builder powerPhase(PowerPhase powerPhase);

        /**
         * <p>
         * Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware.
         * Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Single-phase AC feed
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>L6-30P</b> – (common in US); 30A; single phase
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Three-phase AC feed
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param powerConnector
         *        Specify the power connector that Amazon Web Services should plan to provide for connections to the
         *        hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Single-phase AC feed
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>L6-30P</b> – (common in US); 30A; single phase
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Three-phase AC feed
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see PowerConnector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerConnector
         */
        Builder powerConnector(String powerConnector);

        /**
         * <p>
         * Specify the power connector that Amazon Web Services should plan to provide for connections to the hardware.
         * Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Single-phase AC feed
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>L6-30P</b> – (common in US); 30A; single phase
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Three-phase AC feed
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param powerConnector
         *        Specify the power connector that Amazon Web Services should plan to provide for connections to the
         *        hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Single-phase AC feed
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>L6-30P</b> – (common in US); 30A; single phase
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Three-phase AC feed
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see PowerConnector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerConnector
         */
        Builder powerConnector(PowerConnector powerConnector);

        /**
         * <p>
         * Specify whether the power feed comes above or below the rack.
         * </p>
         * 
         * @param powerFeedDrop
         *        Specify whether the power feed comes above or below the rack.
         * @see PowerFeedDrop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerFeedDrop
         */
        Builder powerFeedDrop(String powerFeedDrop);

        /**
         * <p>
         * Specify whether the power feed comes above or below the rack.
         * </p>
         * 
         * @param powerFeedDrop
         *        Specify whether the power feed comes above or below the rack.
         * @see PowerFeedDrop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerFeedDrop
         */
        Builder powerFeedDrop(PowerFeedDrop powerFeedDrop);

        /**
         * <p>
         * Specify the uplink speed the rack should support for the connection to the Region.
         * </p>
         * 
         * @param uplinkGbps
         *        Specify the uplink speed the rack should support for the connection to the Region.
         * @see UplinkGbps
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UplinkGbps
         */
        Builder uplinkGbps(String uplinkGbps);

        /**
         * <p>
         * Specify the uplink speed the rack should support for the connection to the Region.
         * </p>
         * 
         * @param uplinkGbps
         *        Specify the uplink speed the rack should support for the connection to the Region.
         * @see UplinkGbps
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UplinkGbps
         */
        Builder uplinkGbps(UplinkGbps uplinkGbps);

        /**
         * <p>
         * Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost
         * network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network
         * device that you intend to use to connect the rack to your network. Note the correlation between
         * <code>UplinkGbps</code> and <code>UplinkCount</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 1Gbps - Uplinks available: 1, 2, 4, 6, 8
         * </p>
         * </li>
         * <li>
         * <p>
         * 10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16
         * </p>
         * </li>
         * <li>
         * <p>
         * 40 and 100 Gbps- Uplinks available: 1, 2, 4
         * </p>
         * </li>
         * </ul>
         * 
         * @param uplinkCount
         *        Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the
         *        Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each
         *        Outpost network device that you intend to use to connect the rack to your network. Note the
         *        correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        1Gbps - Uplinks available: 1, 2, 4, 6, 8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        40 and 100 Gbps- Uplinks available: 1, 2, 4
         *        </p>
         *        </li>
         * @see UplinkCount
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UplinkCount
         */
        Builder uplinkCount(String uplinkCount);

        /**
         * <p>
         * Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost
         * network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network
         * device that you intend to use to connect the rack to your network. Note the correlation between
         * <code>UplinkGbps</code> and <code>UplinkCount</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 1Gbps - Uplinks available: 1, 2, 4, 6, 8
         * </p>
         * </li>
         * <li>
         * <p>
         * 10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16
         * </p>
         * </li>
         * <li>
         * <p>
         * 40 and 100 Gbps- Uplinks available: 1, 2, 4
         * </p>
         * </li>
         * </ul>
         * 
         * @param uplinkCount
         *        Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the
         *        Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each
         *        Outpost network device that you intend to use to connect the rack to your network. Note the
         *        correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        1Gbps - Uplinks available: 1, 2, 4, 6, 8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        40 and 100 Gbps- Uplinks available: 1, 2, 4
         *        </p>
         *        </li>
         * @see UplinkCount
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UplinkCount
         */
        Builder uplinkCount(UplinkCount uplinkCount);

        /**
         * <p>
         * Specify the type of fiber that you will use to attach the Outpost to your network.
         * </p>
         * 
         * @param fiberOpticCableType
         *        Specify the type of fiber that you will use to attach the Outpost to your network.
         * @see FiberOpticCableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FiberOpticCableType
         */
        Builder fiberOpticCableType(String fiberOpticCableType);

        /**
         * <p>
         * Specify the type of fiber that you will use to attach the Outpost to your network.
         * </p>
         * 
         * @param fiberOpticCableType
         *        Specify the type of fiber that you will use to attach the Outpost to your network.
         * @see FiberOpticCableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FiberOpticCableType
         */
        Builder fiberOpticCableType(FiberOpticCableType fiberOpticCableType);

        /**
         * <p>
         * Specify the type of optical standard that you will use to attach the Outpost to your network. This field is
         * dependent on uplink speed, fiber type, and distance to the upstream device. For more information about
         * networking requirements for racks, see <a
         * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
         * >Network</a> in the Amazon Web Services Outposts User Guide.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_1000BASE_LX</code>: 1000Base-LX
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_1000BASE_SX</code> : 1000Base-SX
         * </p>
         * </li>
         * </ul>
         * 
         * @param opticalStandard
         *        Specify the type of optical standard that you will use to attach the Outpost to your network. This
         *        field is dependent on uplink speed, fiber type, and distance to the upstream device. For more
         *        information about networking requirements for racks, see <a href=
         *        "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
         *        >Network</a> in the Amazon Web Services Outposts User Guide. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_1000BASE_LX</code>: 1000Base-LX
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_1000BASE_SX</code> : 1000Base-SX
         *        </p>
         *        </li>
         * @see OpticalStandard
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpticalStandard
         */
        Builder opticalStandard(String opticalStandard);

        /**
         * <p>
         * Specify the type of optical standard that you will use to attach the Outpost to your network. This field is
         * dependent on uplink speed, fiber type, and distance to the upstream device. For more information about
         * networking requirements for racks, see <a
         * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
         * >Network</a> in the Amazon Web Services Outposts User Guide.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_1000BASE_LX</code>: 1000Base-LX
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIC_1000BASE_SX</code> : 1000Base-SX
         * </p>
         * </li>
         * </ul>
         * 
         * @param opticalStandard
         *        Specify the type of optical standard that you will use to attach the Outpost to your network. This
         *        field is dependent on uplink speed, fiber type, and distance to the upstream device. For more
         *        information about networking requirements for racks, see <a href=
         *        "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
         *        >Network</a> in the Amazon Web Services Outposts User Guide. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_1000BASE_LX</code>: 1000Base-LX
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIC_1000BASE_SX</code> : 1000Base-SX
         *        </p>
         *        </li>
         * @see OpticalStandard
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpticalStandard
         */
        Builder opticalStandard(OpticalStandard opticalStandard);

        /**
         * <p>
         * Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs.
         * </p>
         * 
         * @param maximumSupportedWeightLbs
         *        Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs.
         * @see MaximumSupportedWeightLbs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumSupportedWeightLbs
         */
        Builder maximumSupportedWeightLbs(String maximumSupportedWeightLbs);

        /**
         * <p>
         * Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs.
         * </p>
         * 
         * @param maximumSupportedWeightLbs
         *        Specify the maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs.
         * @see MaximumSupportedWeightLbs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumSupportedWeightLbs
         */
        Builder maximumSupportedWeightLbs(MaximumSupportedWeightLbs maximumSupportedWeightLbs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String siteId;

        private String powerDrawKva;

        private String powerPhase;

        private String powerConnector;

        private String powerFeedDrop;

        private String uplinkGbps;

        private String uplinkCount;

        private String fiberOpticCableType;

        private String opticalStandard;

        private String maximumSupportedWeightLbs;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSiteRackPhysicalPropertiesRequest model) {
            super(model);
            siteId(model.siteId);
            powerDrawKva(model.powerDrawKva);
            powerPhase(model.powerPhase);
            powerConnector(model.powerConnector);
            powerFeedDrop(model.powerFeedDrop);
            uplinkGbps(model.uplinkGbps);
            uplinkCount(model.uplinkCount);
            fiberOpticCableType(model.fiberOpticCableType);
            opticalStandard(model.opticalStandard);
            maximumSupportedWeightLbs(model.maximumSupportedWeightLbs);
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getPowerDrawKva() {
            return powerDrawKva;
        }

        public final void setPowerDrawKva(String powerDrawKva) {
            this.powerDrawKva = powerDrawKva;
        }

        @Override
        public final Builder powerDrawKva(String powerDrawKva) {
            this.powerDrawKva = powerDrawKva;
            return this;
        }

        @Override
        public final Builder powerDrawKva(PowerDrawKva powerDrawKva) {
            this.powerDrawKva(powerDrawKva == null ? null : powerDrawKva.toString());
            return this;
        }

        public final String getPowerPhase() {
            return powerPhase;
        }

        public final void setPowerPhase(String powerPhase) {
            this.powerPhase = powerPhase;
        }

        @Override
        public final Builder powerPhase(String powerPhase) {
            this.powerPhase = powerPhase;
            return this;
        }

        @Override
        public final Builder powerPhase(PowerPhase powerPhase) {
            this.powerPhase(powerPhase == null ? null : powerPhase.toString());
            return this;
        }

        public final String getPowerConnector() {
            return powerConnector;
        }

        public final void setPowerConnector(String powerConnector) {
            this.powerConnector = powerConnector;
        }

        @Override
        public final Builder powerConnector(String powerConnector) {
            this.powerConnector = powerConnector;
            return this;
        }

        @Override
        public final Builder powerConnector(PowerConnector powerConnector) {
            this.powerConnector(powerConnector == null ? null : powerConnector.toString());
            return this;
        }

        public final String getPowerFeedDrop() {
            return powerFeedDrop;
        }

        public final void setPowerFeedDrop(String powerFeedDrop) {
            this.powerFeedDrop = powerFeedDrop;
        }

        @Override
        public final Builder powerFeedDrop(String powerFeedDrop) {
            this.powerFeedDrop = powerFeedDrop;
            return this;
        }

        @Override
        public final Builder powerFeedDrop(PowerFeedDrop powerFeedDrop) {
            this.powerFeedDrop(powerFeedDrop == null ? null : powerFeedDrop.toString());
            return this;
        }

        public final String getUplinkGbps() {
            return uplinkGbps;
        }

        public final void setUplinkGbps(String uplinkGbps) {
            this.uplinkGbps = uplinkGbps;
        }

        @Override
        public final Builder uplinkGbps(String uplinkGbps) {
            this.uplinkGbps = uplinkGbps;
            return this;
        }

        @Override
        public final Builder uplinkGbps(UplinkGbps uplinkGbps) {
            this.uplinkGbps(uplinkGbps == null ? null : uplinkGbps.toString());
            return this;
        }

        public final String getUplinkCount() {
            return uplinkCount;
        }

        public final void setUplinkCount(String uplinkCount) {
            this.uplinkCount = uplinkCount;
        }

        @Override
        public final Builder uplinkCount(String uplinkCount) {
            this.uplinkCount = uplinkCount;
            return this;
        }

        @Override
        public final Builder uplinkCount(UplinkCount uplinkCount) {
            this.uplinkCount(uplinkCount == null ? null : uplinkCount.toString());
            return this;
        }

        public final String getFiberOpticCableType() {
            return fiberOpticCableType;
        }

        public final void setFiberOpticCableType(String fiberOpticCableType) {
            this.fiberOpticCableType = fiberOpticCableType;
        }

        @Override
        public final Builder fiberOpticCableType(String fiberOpticCableType) {
            this.fiberOpticCableType = fiberOpticCableType;
            return this;
        }

        @Override
        public final Builder fiberOpticCableType(FiberOpticCableType fiberOpticCableType) {
            this.fiberOpticCableType(fiberOpticCableType == null ? null : fiberOpticCableType.toString());
            return this;
        }

        public final String getOpticalStandard() {
            return opticalStandard;
        }

        public final void setOpticalStandard(String opticalStandard) {
            this.opticalStandard = opticalStandard;
        }

        @Override
        public final Builder opticalStandard(String opticalStandard) {
            this.opticalStandard = opticalStandard;
            return this;
        }

        @Override
        public final Builder opticalStandard(OpticalStandard opticalStandard) {
            this.opticalStandard(opticalStandard == null ? null : opticalStandard.toString());
            return this;
        }

        public final String getMaximumSupportedWeightLbs() {
            return maximumSupportedWeightLbs;
        }

        public final void setMaximumSupportedWeightLbs(String maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs = maximumSupportedWeightLbs;
        }

        @Override
        public final Builder maximumSupportedWeightLbs(String maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs = maximumSupportedWeightLbs;
            return this;
        }

        @Override
        public final Builder maximumSupportedWeightLbs(MaximumSupportedWeightLbs maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs(maximumSupportedWeightLbs == null ? null : maximumSupportedWeightLbs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSiteRackPhysicalPropertiesRequest build() {
            return new UpdateSiteRackPhysicalPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
