/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the physical and logistical details for racks at sites. For more information about hardware
 * requirements for racks, see <a
 * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness
 * checklist</a> in the Amazon Web Services Outposts User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RackPhysicalProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<RackPhysicalProperties.Builder, RackPhysicalProperties> {
    private static final SdkField<String> POWER_DRAW_KVA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PowerDrawKva").getter(getter(RackPhysicalProperties::powerDrawKvaAsString))
            .setter(setter(Builder::powerDrawKva))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerDrawKva").build()).build();

    private static final SdkField<String> POWER_PHASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PowerPhase").getter(getter(RackPhysicalProperties::powerPhaseAsString))
            .setter(setter(Builder::powerPhase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerPhase").build()).build();

    private static final SdkField<String> POWER_CONNECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PowerConnector").getter(getter(RackPhysicalProperties::powerConnectorAsString))
            .setter(setter(Builder::powerConnector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerConnector").build()).build();

    private static final SdkField<String> POWER_FEED_DROP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PowerFeedDrop").getter(getter(RackPhysicalProperties::powerFeedDropAsString))
            .setter(setter(Builder::powerFeedDrop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerFeedDrop").build()).build();

    private static final SdkField<String> UPLINK_GBPS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UplinkGbps").getter(getter(RackPhysicalProperties::uplinkGbpsAsString))
            .setter(setter(Builder::uplinkGbps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UplinkGbps").build()).build();

    private static final SdkField<String> UPLINK_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UplinkCount").getter(getter(RackPhysicalProperties::uplinkCountAsString))
            .setter(setter(Builder::uplinkCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UplinkCount").build()).build();

    private static final SdkField<String> FIBER_OPTIC_CABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FiberOpticCableType").getter(getter(RackPhysicalProperties::fiberOpticCableTypeAsString))
            .setter(setter(Builder::fiberOpticCableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FiberOpticCableType").build())
            .build();

    private static final SdkField<String> OPTICAL_STANDARD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpticalStandard").getter(getter(RackPhysicalProperties::opticalStandardAsString))
            .setter(setter(Builder::opticalStandard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpticalStandard").build()).build();

    private static final SdkField<String> MAXIMUM_SUPPORTED_WEIGHT_LBS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaximumSupportedWeightLbs").getter(getter(RackPhysicalProperties::maximumSupportedWeightLbsAsString))
            .setter(setter(Builder::maximumSupportedWeightLbs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumSupportedWeightLbs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POWER_DRAW_KVA_FIELD,
            POWER_PHASE_FIELD, POWER_CONNECTOR_FIELD, POWER_FEED_DROP_FIELD, UPLINK_GBPS_FIELD, UPLINK_COUNT_FIELD,
            FIBER_OPTIC_CABLE_TYPE_FIELD, OPTICAL_STANDARD_FIELD, MAXIMUM_SUPPORTED_WEIGHT_LBS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String powerDrawKva;

    private final String powerPhase;

    private final String powerConnector;

    private final String powerFeedDrop;

    private final String uplinkGbps;

    private final String uplinkCount;

    private final String fiberOpticCableType;

    private final String opticalStandard;

    private final String maximumSupportedWeightLbs;

    private RackPhysicalProperties(BuilderImpl builder) {
        this.powerDrawKva = builder.powerDrawKva;
        this.powerPhase = builder.powerPhase;
        this.powerConnector = builder.powerConnector;
        this.powerFeedDrop = builder.powerFeedDrop;
        this.uplinkGbps = builder.uplinkGbps;
        this.uplinkCount = builder.uplinkCount;
        this.fiberOpticCableType = builder.fiberOpticCableType;
        this.opticalStandard = builder.opticalStandard;
        this.maximumSupportedWeightLbs = builder.maximumSupportedWeightLbs;
    }

    /**
     * <p>
     * The power draw available at the hardware placement position for the rack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerDrawKva} will
     * return {@link PowerDrawKva#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerDrawKvaAsString}.
     * </p>
     * 
     * @return The power draw available at the hardware placement position for the rack.
     * @see PowerDrawKva
     */
    public final PowerDrawKva powerDrawKva() {
        return PowerDrawKva.fromValue(powerDrawKva);
    }

    /**
     * <p>
     * The power draw available at the hardware placement position for the rack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerDrawKva} will
     * return {@link PowerDrawKva#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerDrawKvaAsString}.
     * </p>
     * 
     * @return The power draw available at the hardware placement position for the rack.
     * @see PowerDrawKva
     */
    public final String powerDrawKvaAsString() {
        return powerDrawKva;
    }

    /**
     * <p>
     * The power option that you can provide for hardware.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerPhase} will
     * return {@link PowerPhase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerPhaseAsString}.
     * </p>
     * 
     * @return The power option that you can provide for hardware.
     * @see PowerPhase
     */
    public final PowerPhase powerPhase() {
        return PowerPhase.fromValue(powerPhase);
    }

    /**
     * <p>
     * The power option that you can provide for hardware.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerPhase} will
     * return {@link PowerPhase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerPhaseAsString}.
     * </p>
     * 
     * @return The power option that you can provide for hardware.
     * @see PowerPhase
     */
    public final String powerPhaseAsString() {
        return powerPhase;
    }

    /**
     * <p>
     * The power connector for the hardware.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerConnector}
     * will return {@link PowerConnector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #powerConnectorAsString}.
     * </p>
     * 
     * @return The power connector for the hardware.
     * @see PowerConnector
     */
    public final PowerConnector powerConnector() {
        return PowerConnector.fromValue(powerConnector);
    }

    /**
     * <p>
     * The power connector for the hardware.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerConnector}
     * will return {@link PowerConnector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #powerConnectorAsString}.
     * </p>
     * 
     * @return The power connector for the hardware.
     * @see PowerConnector
     */
    public final String powerConnectorAsString() {
        return powerConnector;
    }

    /**
     * <p>
     * The position of the power feed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerFeedDrop}
     * will return {@link PowerFeedDrop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerFeedDropAsString}.
     * </p>
     * 
     * @return The position of the power feed.
     * @see PowerFeedDrop
     */
    public final PowerFeedDrop powerFeedDrop() {
        return PowerFeedDrop.fromValue(powerFeedDrop);
    }

    /**
     * <p>
     * The position of the power feed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #powerFeedDrop}
     * will return {@link PowerFeedDrop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #powerFeedDropAsString}.
     * </p>
     * 
     * @return The position of the power feed.
     * @see PowerFeedDrop
     */
    public final String powerFeedDropAsString() {
        return powerFeedDrop;
    }

    /**
     * <p>
     * The uplink speed the rack supports for the connection to the Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uplinkGbps} will
     * return {@link UplinkGbps#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uplinkGbpsAsString}.
     * </p>
     * 
     * @return The uplink speed the rack supports for the connection to the Region.
     * @see UplinkGbps
     */
    public final UplinkGbps uplinkGbps() {
        return UplinkGbps.fromValue(uplinkGbps);
    }

    /**
     * <p>
     * The uplink speed the rack supports for the connection to the Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uplinkGbps} will
     * return {@link UplinkGbps#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uplinkGbpsAsString}.
     * </p>
     * 
     * @return The uplink speed the rack supports for the connection to the Region.
     * @see UplinkGbps
     */
    public final String uplinkGbpsAsString() {
        return uplinkGbps;
    }

    /**
     * <p>
     * The number of uplinks each Outpost network device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uplinkCount} will
     * return {@link UplinkCount#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uplinkCountAsString}.
     * </p>
     * 
     * @return The number of uplinks each Outpost network device.
     * @see UplinkCount
     */
    public final UplinkCount uplinkCount() {
        return UplinkCount.fromValue(uplinkCount);
    }

    /**
     * <p>
     * The number of uplinks each Outpost network device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uplinkCount} will
     * return {@link UplinkCount#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uplinkCountAsString}.
     * </p>
     * 
     * @return The number of uplinks each Outpost network device.
     * @see UplinkCount
     */
    public final String uplinkCountAsString() {
        return uplinkCount;
    }

    /**
     * <p>
     * The type of fiber used to attach the Outpost to the network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fiberOpticCableType} will return {@link FiberOpticCableType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fiberOpticCableTypeAsString}.
     * </p>
     * 
     * @return The type of fiber used to attach the Outpost to the network.
     * @see FiberOpticCableType
     */
    public final FiberOpticCableType fiberOpticCableType() {
        return FiberOpticCableType.fromValue(fiberOpticCableType);
    }

    /**
     * <p>
     * The type of fiber used to attach the Outpost to the network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fiberOpticCableType} will return {@link FiberOpticCableType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fiberOpticCableTypeAsString}.
     * </p>
     * 
     * @return The type of fiber used to attach the Outpost to the network.
     * @see FiberOpticCableType
     */
    public final String fiberOpticCableTypeAsString() {
        return fiberOpticCableType;
    }

    /**
     * <p>
     * The type of optical standard used to attach the Outpost to the network. This field is dependent on uplink speed,
     * fiber type, and distance to the upstream device. For more information about networking requirements for racks,
     * see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
     * >Network</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opticalStandard}
     * will return {@link OpticalStandard#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opticalStandardAsString}.
     * </p>
     * 
     * @return The type of optical standard used to attach the Outpost to the network. This field is dependent on uplink
     *         speed, fiber type, and distance to the upstream device. For more information about networking
     *         requirements for racks, see <a href=
     *         "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
     *         >Network</a> in the Amazon Web Services Outposts User Guide.
     * @see OpticalStandard
     */
    public final OpticalStandard opticalStandard() {
        return OpticalStandard.fromValue(opticalStandard);
    }

    /**
     * <p>
     * The type of optical standard used to attach the Outpost to the network. This field is dependent on uplink speed,
     * fiber type, and distance to the upstream device. For more information about networking requirements for racks,
     * see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
     * >Network</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opticalStandard}
     * will return {@link OpticalStandard#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opticalStandardAsString}.
     * </p>
     * 
     * @return The type of optical standard used to attach the Outpost to the network. This field is dependent on uplink
     *         speed, fiber type, and distance to the upstream device. For more information about networking
     *         requirements for racks, see <a href=
     *         "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
     *         >Network</a> in the Amazon Web Services Outposts User Guide.
     * @see OpticalStandard
     */
    public final String opticalStandardAsString() {
        return opticalStandard;
    }

    /**
     * <p>
     * The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumSupportedWeightLbs} will return {@link MaximumSupportedWeightLbs#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumSupportedWeightLbsAsString}.
     * </p>
     * 
     * @return The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg).
     * @see MaximumSupportedWeightLbs
     */
    public final MaximumSupportedWeightLbs maximumSupportedWeightLbs() {
        return MaximumSupportedWeightLbs.fromValue(maximumSupportedWeightLbs);
    }

    /**
     * <p>
     * The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maximumSupportedWeightLbs} will return {@link MaximumSupportedWeightLbs#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maximumSupportedWeightLbsAsString}.
     * </p>
     * 
     * @return The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg).
     * @see MaximumSupportedWeightLbs
     */
    public final String maximumSupportedWeightLbsAsString() {
        return maximumSupportedWeightLbs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(powerDrawKvaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(powerPhaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(powerConnectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(powerFeedDropAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkGbpsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkCountAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fiberOpticCableTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(opticalStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumSupportedWeightLbsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RackPhysicalProperties)) {
            return false;
        }
        RackPhysicalProperties other = (RackPhysicalProperties) obj;
        return Objects.equals(powerDrawKvaAsString(), other.powerDrawKvaAsString())
                && Objects.equals(powerPhaseAsString(), other.powerPhaseAsString())
                && Objects.equals(powerConnectorAsString(), other.powerConnectorAsString())
                && Objects.equals(powerFeedDropAsString(), other.powerFeedDropAsString())
                && Objects.equals(uplinkGbpsAsString(), other.uplinkGbpsAsString())
                && Objects.equals(uplinkCountAsString(), other.uplinkCountAsString())
                && Objects.equals(fiberOpticCableTypeAsString(), other.fiberOpticCableTypeAsString())
                && Objects.equals(opticalStandardAsString(), other.opticalStandardAsString())
                && Objects.equals(maximumSupportedWeightLbsAsString(), other.maximumSupportedWeightLbsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RackPhysicalProperties").add("PowerDrawKva", powerDrawKvaAsString())
                .add("PowerPhase", powerPhaseAsString()).add("PowerConnector", powerConnectorAsString())
                .add("PowerFeedDrop", powerFeedDropAsString()).add("UplinkGbps", uplinkGbpsAsString())
                .add("UplinkCount", uplinkCountAsString()).add("FiberOpticCableType", fiberOpticCableTypeAsString())
                .add("OpticalStandard", opticalStandardAsString())
                .add("MaximumSupportedWeightLbs", maximumSupportedWeightLbsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PowerDrawKva":
            return Optional.ofNullable(clazz.cast(powerDrawKvaAsString()));
        case "PowerPhase":
            return Optional.ofNullable(clazz.cast(powerPhaseAsString()));
        case "PowerConnector":
            return Optional.ofNullable(clazz.cast(powerConnectorAsString()));
        case "PowerFeedDrop":
            return Optional.ofNullable(clazz.cast(powerFeedDropAsString()));
        case "UplinkGbps":
            return Optional.ofNullable(clazz.cast(uplinkGbpsAsString()));
        case "UplinkCount":
            return Optional.ofNullable(clazz.cast(uplinkCountAsString()));
        case "FiberOpticCableType":
            return Optional.ofNullable(clazz.cast(fiberOpticCableTypeAsString()));
        case "OpticalStandard":
            return Optional.ofNullable(clazz.cast(opticalStandardAsString()));
        case "MaximumSupportedWeightLbs":
            return Optional.ofNullable(clazz.cast(maximumSupportedWeightLbsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RackPhysicalProperties, T> g) {
        return obj -> g.apply((RackPhysicalProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RackPhysicalProperties> {
        /**
         * <p>
         * The power draw available at the hardware placement position for the rack.
         * </p>
         * 
         * @param powerDrawKva
         *        The power draw available at the hardware placement position for the rack.
         * @see PowerDrawKva
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerDrawKva
         */
        Builder powerDrawKva(String powerDrawKva);

        /**
         * <p>
         * The power draw available at the hardware placement position for the rack.
         * </p>
         * 
         * @param powerDrawKva
         *        The power draw available at the hardware placement position for the rack.
         * @see PowerDrawKva
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerDrawKva
         */
        Builder powerDrawKva(PowerDrawKva powerDrawKva);

        /**
         * <p>
         * The power option that you can provide for hardware.
         * </p>
         * 
         * @param powerPhase
         *        The power option that you can provide for hardware.
         * @see PowerPhase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerPhase
         */
        Builder powerPhase(String powerPhase);

        /**
         * <p>
         * The power option that you can provide for hardware.
         * </p>
         * 
         * @param powerPhase
         *        The power option that you can provide for hardware.
         * @see PowerPhase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerPhase
         */
        Builder powerPhase(PowerPhase powerPhase);

        /**
         * <p>
         * The power connector for the hardware.
         * </p>
         * 
         * @param powerConnector
         *        The power connector for the hardware.
         * @see PowerConnector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerConnector
         */
        Builder powerConnector(String powerConnector);

        /**
         * <p>
         * The power connector for the hardware.
         * </p>
         * 
         * @param powerConnector
         *        The power connector for the hardware.
         * @see PowerConnector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerConnector
         */
        Builder powerConnector(PowerConnector powerConnector);

        /**
         * <p>
         * The position of the power feed.
         * </p>
         * 
         * @param powerFeedDrop
         *        The position of the power feed.
         * @see PowerFeedDrop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerFeedDrop
         */
        Builder powerFeedDrop(String powerFeedDrop);

        /**
         * <p>
         * The position of the power feed.
         * </p>
         * 
         * @param powerFeedDrop
         *        The position of the power feed.
         * @see PowerFeedDrop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PowerFeedDrop
         */
        Builder powerFeedDrop(PowerFeedDrop powerFeedDrop);

        /**
         * <p>
         * The uplink speed the rack supports for the connection to the Region.
         * </p>
         * 
         * @param uplinkGbps
         *        The uplink speed the rack supports for the connection to the Region.
         * @see UplinkGbps
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UplinkGbps
         */
        Builder uplinkGbps(String uplinkGbps);

        /**
         * <p>
         * The uplink speed the rack supports for the connection to the Region.
         * </p>
         * 
         * @param uplinkGbps
         *        The uplink speed the rack supports for the connection to the Region.
         * @see UplinkGbps
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UplinkGbps
         */
        Builder uplinkGbps(UplinkGbps uplinkGbps);

        /**
         * <p>
         * The number of uplinks each Outpost network device.
         * </p>
         * 
         * @param uplinkCount
         *        The number of uplinks each Outpost network device.
         * @see UplinkCount
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UplinkCount
         */
        Builder uplinkCount(String uplinkCount);

        /**
         * <p>
         * The number of uplinks each Outpost network device.
         * </p>
         * 
         * @param uplinkCount
         *        The number of uplinks each Outpost network device.
         * @see UplinkCount
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UplinkCount
         */
        Builder uplinkCount(UplinkCount uplinkCount);

        /**
         * <p>
         * The type of fiber used to attach the Outpost to the network.
         * </p>
         * 
         * @param fiberOpticCableType
         *        The type of fiber used to attach the Outpost to the network.
         * @see FiberOpticCableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FiberOpticCableType
         */
        Builder fiberOpticCableType(String fiberOpticCableType);

        /**
         * <p>
         * The type of fiber used to attach the Outpost to the network.
         * </p>
         * 
         * @param fiberOpticCableType
         *        The type of fiber used to attach the Outpost to the network.
         * @see FiberOpticCableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FiberOpticCableType
         */
        Builder fiberOpticCableType(FiberOpticCableType fiberOpticCableType);

        /**
         * <p>
         * The type of optical standard used to attach the Outpost to the network. This field is dependent on uplink
         * speed, fiber type, and distance to the upstream device. For more information about networking requirements
         * for racks, see <a
         * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
         * >Network</a> in the Amazon Web Services Outposts User Guide.
         * </p>
         * 
         * @param opticalStandard
         *        The type of optical standard used to attach the Outpost to the network. This field is dependent on
         *        uplink speed, fiber type, and distance to the upstream device. For more information about networking
         *        requirements for racks, see <a href=
         *        "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
         *        >Network</a> in the Amazon Web Services Outposts User Guide.
         * @see OpticalStandard
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpticalStandard
         */
        Builder opticalStandard(String opticalStandard);

        /**
         * <p>
         * The type of optical standard used to attach the Outpost to the network. This field is dependent on uplink
         * speed, fiber type, and distance to the upstream device. For more information about networking requirements
         * for racks, see <a
         * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
         * >Network</a> in the Amazon Web Services Outposts User Guide.
         * </p>
         * 
         * @param opticalStandard
         *        The type of optical standard used to attach the Outpost to the network. This field is dependent on
         *        uplink speed, fiber type, and distance to the upstream device. For more information about networking
         *        requirements for racks, see <a href=
         *        "https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking"
         *        >Network</a> in the Amazon Web Services Outposts User Guide.
         * @see OpticalStandard
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpticalStandard
         */
        Builder opticalStandard(OpticalStandard opticalStandard);

        /**
         * <p>
         * The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg).
         * </p>
         * 
         * @param maximumSupportedWeightLbs
         *        The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg).
         * @see MaximumSupportedWeightLbs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumSupportedWeightLbs
         */
        Builder maximumSupportedWeightLbs(String maximumSupportedWeightLbs);

        /**
         * <p>
         * The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg).
         * </p>
         * 
         * @param maximumSupportedWeightLbs
         *        The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg).
         * @see MaximumSupportedWeightLbs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaximumSupportedWeightLbs
         */
        Builder maximumSupportedWeightLbs(MaximumSupportedWeightLbs maximumSupportedWeightLbs);
    }

    static final class BuilderImpl implements Builder {
        private String powerDrawKva;

        private String powerPhase;

        private String powerConnector;

        private String powerFeedDrop;

        private String uplinkGbps;

        private String uplinkCount;

        private String fiberOpticCableType;

        private String opticalStandard;

        private String maximumSupportedWeightLbs;

        private BuilderImpl() {
        }

        private BuilderImpl(RackPhysicalProperties model) {
            powerDrawKva(model.powerDrawKva);
            powerPhase(model.powerPhase);
            powerConnector(model.powerConnector);
            powerFeedDrop(model.powerFeedDrop);
            uplinkGbps(model.uplinkGbps);
            uplinkCount(model.uplinkCount);
            fiberOpticCableType(model.fiberOpticCableType);
            opticalStandard(model.opticalStandard);
            maximumSupportedWeightLbs(model.maximumSupportedWeightLbs);
        }

        public final String getPowerDrawKva() {
            return powerDrawKva;
        }

        public final void setPowerDrawKva(String powerDrawKva) {
            this.powerDrawKva = powerDrawKva;
        }

        @Override
        @Transient
        public final Builder powerDrawKva(String powerDrawKva) {
            this.powerDrawKva = powerDrawKva;
            return this;
        }

        @Override
        @Transient
        public final Builder powerDrawKva(PowerDrawKva powerDrawKva) {
            this.powerDrawKva(powerDrawKva == null ? null : powerDrawKva.toString());
            return this;
        }

        public final String getPowerPhase() {
            return powerPhase;
        }

        public final void setPowerPhase(String powerPhase) {
            this.powerPhase = powerPhase;
        }

        @Override
        @Transient
        public final Builder powerPhase(String powerPhase) {
            this.powerPhase = powerPhase;
            return this;
        }

        @Override
        @Transient
        public final Builder powerPhase(PowerPhase powerPhase) {
            this.powerPhase(powerPhase == null ? null : powerPhase.toString());
            return this;
        }

        public final String getPowerConnector() {
            return powerConnector;
        }

        public final void setPowerConnector(String powerConnector) {
            this.powerConnector = powerConnector;
        }

        @Override
        @Transient
        public final Builder powerConnector(String powerConnector) {
            this.powerConnector = powerConnector;
            return this;
        }

        @Override
        @Transient
        public final Builder powerConnector(PowerConnector powerConnector) {
            this.powerConnector(powerConnector == null ? null : powerConnector.toString());
            return this;
        }

        public final String getPowerFeedDrop() {
            return powerFeedDrop;
        }

        public final void setPowerFeedDrop(String powerFeedDrop) {
            this.powerFeedDrop = powerFeedDrop;
        }

        @Override
        @Transient
        public final Builder powerFeedDrop(String powerFeedDrop) {
            this.powerFeedDrop = powerFeedDrop;
            return this;
        }

        @Override
        @Transient
        public final Builder powerFeedDrop(PowerFeedDrop powerFeedDrop) {
            this.powerFeedDrop(powerFeedDrop == null ? null : powerFeedDrop.toString());
            return this;
        }

        public final String getUplinkGbps() {
            return uplinkGbps;
        }

        public final void setUplinkGbps(String uplinkGbps) {
            this.uplinkGbps = uplinkGbps;
        }

        @Override
        @Transient
        public final Builder uplinkGbps(String uplinkGbps) {
            this.uplinkGbps = uplinkGbps;
            return this;
        }

        @Override
        @Transient
        public final Builder uplinkGbps(UplinkGbps uplinkGbps) {
            this.uplinkGbps(uplinkGbps == null ? null : uplinkGbps.toString());
            return this;
        }

        public final String getUplinkCount() {
            return uplinkCount;
        }

        public final void setUplinkCount(String uplinkCount) {
            this.uplinkCount = uplinkCount;
        }

        @Override
        @Transient
        public final Builder uplinkCount(String uplinkCount) {
            this.uplinkCount = uplinkCount;
            return this;
        }

        @Override
        @Transient
        public final Builder uplinkCount(UplinkCount uplinkCount) {
            this.uplinkCount(uplinkCount == null ? null : uplinkCount.toString());
            return this;
        }

        public final String getFiberOpticCableType() {
            return fiberOpticCableType;
        }

        public final void setFiberOpticCableType(String fiberOpticCableType) {
            this.fiberOpticCableType = fiberOpticCableType;
        }

        @Override
        @Transient
        public final Builder fiberOpticCableType(String fiberOpticCableType) {
            this.fiberOpticCableType = fiberOpticCableType;
            return this;
        }

        @Override
        @Transient
        public final Builder fiberOpticCableType(FiberOpticCableType fiberOpticCableType) {
            this.fiberOpticCableType(fiberOpticCableType == null ? null : fiberOpticCableType.toString());
            return this;
        }

        public final String getOpticalStandard() {
            return opticalStandard;
        }

        public final void setOpticalStandard(String opticalStandard) {
            this.opticalStandard = opticalStandard;
        }

        @Override
        @Transient
        public final Builder opticalStandard(String opticalStandard) {
            this.opticalStandard = opticalStandard;
            return this;
        }

        @Override
        @Transient
        public final Builder opticalStandard(OpticalStandard opticalStandard) {
            this.opticalStandard(opticalStandard == null ? null : opticalStandard.toString());
            return this;
        }

        public final String getMaximumSupportedWeightLbs() {
            return maximumSupportedWeightLbs;
        }

        public final void setMaximumSupportedWeightLbs(String maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs = maximumSupportedWeightLbs;
        }

        @Override
        @Transient
        public final Builder maximumSupportedWeightLbs(String maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs = maximumSupportedWeightLbs;
            return this;
        }

        @Override
        @Transient
        public final Builder maximumSupportedWeightLbs(MaximumSupportedWeightLbs maximumSupportedWeightLbs) {
            this.maximumSupportedWeightLbs(maximumSupportedWeightLbs == null ? null : maximumSupportedWeightLbs.toString());
            return this;
        }

        @Override
        public RackPhysicalProperties build() {
            return new RackPhysicalProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
