/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOutpostRequest extends OutpostsRequest implements
        ToCopyableBuilder<CreateOutpostRequest.Builder, CreateOutpostRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateOutpostRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateOutpostRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(CreateOutpostRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(CreateOutpostRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId").getter(getter(CreateOutpostRequest::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateOutpostRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SUPPORTED_HARDWARE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportedHardwareType").getter(getter(CreateOutpostRequest::supportedHardwareTypeAsString))
            .setter(setter(Builder::supportedHardwareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedHardwareType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SITE_ID_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, TAGS_FIELD, SUPPORTED_HARDWARE_TYPE_FIELD));

    private final String name;

    private final String description;

    private final String siteId;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Map<String, String> tags;

    private final String supportedHardwareType;

    private CreateOutpostRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.siteId = builder.siteId;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tags = builder.tags;
        this.supportedHardwareType = builder.supportedHardwareType;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * 
     * @return The ID or the Amazon Resource Name (ARN) of the site.
     */
    public final String siteId() {
        return siteId;
    }

    /**
     * Returns the value of the AvailabilityZone property for this object.
     * 
     * @return The value of the AvailabilityZone property for this object.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * Returns the value of the AvailabilityZoneId property for this object.
     * 
     * @return The value of the AvailabilityZoneId property for this object.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to the Outpost.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the Outpost.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #supportedHardwareType} will return {@link SupportedHardwareType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #supportedHardwareTypeAsString}.
     * </p>
     * 
     * @return The type of hardware for this Outpost.
     * @see SupportedHardwareType
     */
    public final SupportedHardwareType supportedHardwareType() {
        return SupportedHardwareType.fromValue(supportedHardwareType);
    }

    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #supportedHardwareType} will return {@link SupportedHardwareType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #supportedHardwareTypeAsString}.
     * </p>
     * 
     * @return The type of hardware for this Outpost.
     * @see SupportedHardwareType
     */
    public final String supportedHardwareTypeAsString() {
        return supportedHardwareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(supportedHardwareTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutpostRequest)) {
            return false;
        }
        CreateOutpostRequest other = (CreateOutpostRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(siteId(), other.siteId()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(supportedHardwareTypeAsString(), other.supportedHardwareTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOutpostRequest").add("Name", name()).add("Description", description())
                .add("SiteId", siteId()).add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("Tags", hasTags() ? tags() : null)
                .add("SupportedHardwareType", supportedHardwareTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SupportedHardwareType":
            return Optional.ofNullable(clazz.cast(supportedHardwareTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOutpostRequest, T> g) {
        return obj -> g.apply((CreateOutpostRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOutpostRequest> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID or the Amazon Resource Name (ARN) of the site.
         * </p>
         * 
         * @param siteId
         *        The ID or the Amazon Resource Name (ARN) of the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        /**
         * Sets the value of the AvailabilityZone property for this object.
         *
         * @param availabilityZone
         *        The new value for the AvailabilityZone property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * Sets the value of the AvailabilityZoneId property for this object.
         *
         * @param availabilityZoneId
         *        The new value for the AvailabilityZoneId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The tags to apply to the Outpost.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of hardware for this Outpost.
         * </p>
         * 
         * @param supportedHardwareType
         *        The type of hardware for this Outpost.
         * @see SupportedHardwareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedHardwareType
         */
        Builder supportedHardwareType(String supportedHardwareType);

        /**
         * <p>
         * The type of hardware for this Outpost.
         * </p>
         * 
         * @param supportedHardwareType
         *        The type of hardware for this Outpost.
         * @see SupportedHardwareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedHardwareType
         */
        Builder supportedHardwareType(SupportedHardwareType supportedHardwareType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String siteId;

        private String availabilityZone;

        private String availabilityZoneId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String supportedHardwareType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutpostRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            siteId(model.siteId);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            tags(model.tags);
            supportedHardwareType(model.supportedHardwareType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        @Transient
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        @Transient
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getSupportedHardwareType() {
            return supportedHardwareType;
        }

        public final void setSupportedHardwareType(String supportedHardwareType) {
            this.supportedHardwareType = supportedHardwareType;
        }

        @Override
        @Transient
        public final Builder supportedHardwareType(String supportedHardwareType) {
            this.supportedHardwareType = supportedHardwareType;
            return this;
        }

        @Override
        @Transient
        public final Builder supportedHardwareType(SupportedHardwareType supportedHardwareType) {
            this.supportedHardwareType(supportedHardwareType == null ? null : supportedHardwareType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOutpostRequest build() {
            return new CreateOutpostRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
