/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> CONTACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactName").getter(getter(Address::contactName)).setter(setter(Builder::contactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactName").build()).build();

    private static final SdkField<String> CONTACT_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactPhoneNumber").getter(getter(Address::contactPhoneNumber))
            .setter(setter(Builder::contactPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactPhoneNumber").build())
            .build();

    private static final SdkField<String> ADDRESS_LINE1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine1").getter(getter(Address::addressLine1)).setter(setter(Builder::addressLine1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine1").build()).build();

    private static final SdkField<String> ADDRESS_LINE2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine2").getter(getter(Address::addressLine2)).setter(setter(Builder::addressLine2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine2").build()).build();

    private static final SdkField<String> ADDRESS_LINE3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine3").getter(getter(Address::addressLine3)).setter(setter(Builder::addressLine3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine3").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(Address::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateOrRegion").getter(getter(Address::stateOrRegion)).setter(setter(Builder::stateOrRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateOrRegion").build()).build();

    private static final SdkField<String> DISTRICT_OR_COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistrictOrCounty").getter(getter(Address::districtOrCounty)).setter(setter(Builder::districtOrCounty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistrictOrCounty").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(Address::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(Address::countryCode)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final SdkField<String> MUNICIPALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Municipality").getter(getter(Address::municipality)).setter(setter(Builder::municipality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Municipality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_NAME_FIELD,
            CONTACT_PHONE_NUMBER_FIELD, ADDRESS_LINE1_FIELD, ADDRESS_LINE2_FIELD, ADDRESS_LINE3_FIELD, CITY_FIELD,
            STATE_OR_REGION_FIELD, DISTRICT_OR_COUNTY_FIELD, POSTAL_CODE_FIELD, COUNTRY_CODE_FIELD, MUNICIPALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contactName;

    private final String contactPhoneNumber;

    private final String addressLine1;

    private final String addressLine2;

    private final String addressLine3;

    private final String city;

    private final String stateOrRegion;

    private final String districtOrCounty;

    private final String postalCode;

    private final String countryCode;

    private final String municipality;

    private Address(BuilderImpl builder) {
        this.contactName = builder.contactName;
        this.contactPhoneNumber = builder.contactPhoneNumber;
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.addressLine3 = builder.addressLine3;
        this.city = builder.city;
        this.stateOrRegion = builder.stateOrRegion;
        this.districtOrCounty = builder.districtOrCounty;
        this.postalCode = builder.postalCode;
        this.countryCode = builder.countryCode;
        this.municipality = builder.municipality;
    }

    /**
     * <p>
     * The name of the contact.
     * </p>
     * 
     * @return The name of the contact.
     */
    public final String contactName() {
        return contactName;
    }

    /**
     * <p>
     * The phone number of the contact.
     * </p>
     * 
     * @return The phone number of the contact.
     */
    public final String contactPhoneNumber() {
        return contactPhoneNumber;
    }

    /**
     * <p>
     * The first line of the address.
     * </p>
     * 
     * @return The first line of the address.
     */
    public final String addressLine1() {
        return addressLine1;
    }

    /**
     * <p>
     * The second line of the address.
     * </p>
     * 
     * @return The second line of the address.
     */
    public final String addressLine2() {
        return addressLine2;
    }

    /**
     * <p>
     * The third line of the address.
     * </p>
     * 
     * @return The third line of the address.
     */
    public final String addressLine3() {
        return addressLine3;
    }

    /**
     * <p>
     * The city for the address.
     * </p>
     * 
     * @return The city for the address.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The state for the address.
     * </p>
     * 
     * @return The state for the address.
     */
    public final String stateOrRegion() {
        return stateOrRegion;
    }

    /**
     * <p>
     * The district or county for the address.
     * </p>
     * 
     * @return The district or county for the address.
     */
    public final String districtOrCounty() {
        return districtOrCounty;
    }

    /**
     * <p>
     * The postal code for the address.
     * </p>
     * 
     * @return The postal code for the address.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The ISO-3166 two-letter country code for the address.
     * </p>
     * 
     * @return The ISO-3166 two-letter country code for the address.
     */
    public final String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The municipality for the address.
     * </p>
     * 
     * @return The municipality for the address.
     */
    public final String municipality() {
        return municipality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactName());
        hashCode = 31 * hashCode + Objects.hashCode(contactPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine1());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine2());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine3());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrRegion());
        hashCode = 31 * hashCode + Objects.hashCode(districtOrCounty());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(municipality());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(contactName(), other.contactName())
                && Objects.equals(contactPhoneNumber(), other.contactPhoneNumber())
                && Objects.equals(addressLine1(), other.addressLine1()) && Objects.equals(addressLine2(), other.addressLine2())
                && Objects.equals(addressLine3(), other.addressLine3()) && Objects.equals(city(), other.city())
                && Objects.equals(stateOrRegion(), other.stateOrRegion())
                && Objects.equals(districtOrCounty(), other.districtOrCounty())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(countryCode(), other.countryCode())
                && Objects.equals(municipality(), other.municipality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address").add("ContactName", contactName()).add("ContactPhoneNumber", contactPhoneNumber())
                .add("AddressLine1", addressLine1()).add("AddressLine2", addressLine2()).add("AddressLine3", addressLine3())
                .add("City", city()).add("StateOrRegion", stateOrRegion()).add("DistrictOrCounty", districtOrCounty())
                .add("PostalCode", postalCode()).add("CountryCode", countryCode()).add("Municipality", municipality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactName":
            return Optional.ofNullable(clazz.cast(contactName()));
        case "ContactPhoneNumber":
            return Optional.ofNullable(clazz.cast(contactPhoneNumber()));
        case "AddressLine1":
            return Optional.ofNullable(clazz.cast(addressLine1()));
        case "AddressLine2":
            return Optional.ofNullable(clazz.cast(addressLine2()));
        case "AddressLine3":
            return Optional.ofNullable(clazz.cast(addressLine3()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "StateOrRegion":
            return Optional.ofNullable(clazz.cast(stateOrRegion()));
        case "DistrictOrCounty":
            return Optional.ofNullable(clazz.cast(districtOrCounty()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "Municipality":
            return Optional.ofNullable(clazz.cast(municipality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The name of the contact.
         * </p>
         * 
         * @param contactName
         *        The name of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactName(String contactName);

        /**
         * <p>
         * The phone number of the contact.
         * </p>
         * 
         * @param contactPhoneNumber
         *        The phone number of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPhoneNumber(String contactPhoneNumber);

        /**
         * <p>
         * The first line of the address.
         * </p>
         * 
         * @param addressLine1
         *        The first line of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine1(String addressLine1);

        /**
         * <p>
         * The second line of the address.
         * </p>
         * 
         * @param addressLine2
         *        The second line of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine2(String addressLine2);

        /**
         * <p>
         * The third line of the address.
         * </p>
         * 
         * @param addressLine3
         *        The third line of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine3(String addressLine3);

        /**
         * <p>
         * The city for the address.
         * </p>
         * 
         * @param city
         *        The city for the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The state for the address.
         * </p>
         * 
         * @param stateOrRegion
         *        The state for the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrRegion(String stateOrRegion);

        /**
         * <p>
         * The district or county for the address.
         * </p>
         * 
         * @param districtOrCounty
         *        The district or county for the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder districtOrCounty(String districtOrCounty);

        /**
         * <p>
         * The postal code for the address.
         * </p>
         * 
         * @param postalCode
         *        The postal code for the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The ISO-3166 two-letter country code for the address.
         * </p>
         * 
         * @param countryCode
         *        The ISO-3166 two-letter country code for the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * The municipality for the address.
         * </p>
         * 
         * @param municipality
         *        The municipality for the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder municipality(String municipality);
    }

    static final class BuilderImpl implements Builder {
        private String contactName;

        private String contactPhoneNumber;

        private String addressLine1;

        private String addressLine2;

        private String addressLine3;

        private String city;

        private String stateOrRegion;

        private String districtOrCounty;

        private String postalCode;

        private String countryCode;

        private String municipality;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            contactName(model.contactName);
            contactPhoneNumber(model.contactPhoneNumber);
            addressLine1(model.addressLine1);
            addressLine2(model.addressLine2);
            addressLine3(model.addressLine3);
            city(model.city);
            stateOrRegion(model.stateOrRegion);
            districtOrCounty(model.districtOrCounty);
            postalCode(model.postalCode);
            countryCode(model.countryCode);
            municipality(model.municipality);
        }

        public final String getContactName() {
            return contactName;
        }

        public final void setContactName(String contactName) {
            this.contactName = contactName;
        }

        @Override
        @Transient
        public final Builder contactName(String contactName) {
            this.contactName = contactName;
            return this;
        }

        public final String getContactPhoneNumber() {
            return contactPhoneNumber;
        }

        public final void setContactPhoneNumber(String contactPhoneNumber) {
            this.contactPhoneNumber = contactPhoneNumber;
        }

        @Override
        @Transient
        public final Builder contactPhoneNumber(String contactPhoneNumber) {
            this.contactPhoneNumber = contactPhoneNumber;
            return this;
        }

        public final String getAddressLine1() {
            return addressLine1;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        @Override
        @Transient
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final String getAddressLine2() {
            return addressLine2;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        @Override
        @Transient
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final String getAddressLine3() {
            return addressLine3;
        }

        public final void setAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
        }

        @Override
        @Transient
        public final Builder addressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        @Transient
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getStateOrRegion() {
            return stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        @Transient
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        public final String getDistrictOrCounty() {
            return districtOrCounty;
        }

        public final void setDistrictOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
        }

        @Override
        @Transient
        public final Builder districtOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        @Transient
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        @Transient
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getMunicipality() {
            return municipality;
        }

        public final void setMunicipality(String municipality) {
            this.municipality = municipality;
        }

        @Override
        @Transient
        public final Builder municipality(String municipality) {
            this.municipality = municipality;
            return this;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
