/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.outposts.model.LineItemStatus;
import software.amazon.awssdk.services.outposts.model.LineItemStatusCountsCopier;
import software.amazon.awssdk.services.outposts.model.OrderStatus;
import software.amazon.awssdk.services.outposts.model.OrderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrderSummary> {
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(OrderSummary.getter(OrderSummary::outpostId)).setter(OrderSummary.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()}).build();
    private static final SdkField<String> ORDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderId").getter(OrderSummary.getter(OrderSummary::orderId)).setter(OrderSummary.setter(Builder::orderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()}).build();
    private static final SdkField<String> ORDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderType").getter(OrderSummary.getter(OrderSummary::orderTypeAsString)).setter(OrderSummary.setter(Builder::orderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OrderSummary.getter(OrderSummary::statusAsString)).setter(OrderSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, Integer>> LINE_ITEM_COUNTS_BY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LineItemCountsByStatus").getter(OrderSummary.getter(OrderSummary::lineItemCountsByStatusAsStrings)).setter(OrderSummary.setter(Builder::lineItemCountsByStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemCountsByStatus").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> ORDER_SUBMISSION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OrderSubmissionDate").getter(OrderSummary.getter(OrderSummary::orderSubmissionDate)).setter(OrderSummary.setter(Builder::orderSubmissionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderSubmissionDate").build()}).build();
    private static final SdkField<Instant> ORDER_FULFILLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OrderFulfilledDate").getter(OrderSummary.getter(OrderSummary::orderFulfilledDate)).setter(OrderSummary.setter(Builder::orderFulfilledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderFulfilledDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ID_FIELD, ORDER_ID_FIELD, ORDER_TYPE_FIELD, STATUS_FIELD, LINE_ITEM_COUNTS_BY_STATUS_FIELD, ORDER_SUBMISSION_DATE_FIELD, ORDER_FULFILLED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outpostId;
    private final String orderId;
    private final String orderType;
    private final String status;
    private final Map<String, Integer> lineItemCountsByStatus;
    private final Instant orderSubmissionDate;
    private final Instant orderFulfilledDate;

    private OrderSummary(BuilderImpl builder) {
        this.outpostId = builder.outpostId;
        this.orderId = builder.orderId;
        this.orderType = builder.orderType;
        this.status = builder.status;
        this.lineItemCountsByStatus = builder.lineItemCountsByStatus;
        this.orderSubmissionDate = builder.orderSubmissionDate;
        this.orderFulfilledDate = builder.orderFulfilledDate;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String orderId() {
        return this.orderId;
    }

    public final OrderType orderType() {
        return OrderType.fromValue(this.orderType);
    }

    public final String orderTypeAsString() {
        return this.orderType;
    }

    public final OrderStatus status() {
        return OrderStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Map<LineItemStatus, Integer> lineItemCountsByStatus() {
        return LineItemStatusCountsCopier.copyStringToEnum(this.lineItemCountsByStatus);
    }

    public final boolean hasLineItemCountsByStatus() {
        return this.lineItemCountsByStatus != null && !(this.lineItemCountsByStatus instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> lineItemCountsByStatusAsStrings() {
        return this.lineItemCountsByStatus;
    }

    public final Instant orderSubmissionDate() {
        return this.orderSubmissionDate;
    }

    public final Instant orderFulfilledDate() {
        return this.orderFulfilledDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineItemCountsByStatus() ? this.lineItemCountsByStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.orderSubmissionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderFulfilledDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderSummary)) {
            return false;
        }
        OrderSummary other = (OrderSummary)obj;
        return Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.orderId(), other.orderId()) && Objects.equals(this.orderTypeAsString(), other.orderTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasLineItemCountsByStatus() == other.hasLineItemCountsByStatus() && Objects.equals(this.lineItemCountsByStatusAsStrings(), other.lineItemCountsByStatusAsStrings()) && Objects.equals(this.orderSubmissionDate(), other.orderSubmissionDate()) && Objects.equals(this.orderFulfilledDate(), other.orderFulfilledDate());
    }

    public final String toString() {
        return ToString.builder((String)"OrderSummary").add("OutpostId", (Object)this.outpostId()).add("OrderId", (Object)this.orderId()).add("OrderType", (Object)this.orderTypeAsString()).add("Status", (Object)this.statusAsString()).add("LineItemCountsByStatus", this.hasLineItemCountsByStatus() ? this.lineItemCountsByStatusAsStrings() : null).add("OrderSubmissionDate", (Object)this.orderSubmissionDate()).add("OrderFulfilledDate", (Object)this.orderFulfilledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "OrderId": {
                return Optional.ofNullable(clazz.cast(this.orderId()));
            }
            case "OrderType": {
                return Optional.ofNullable(clazz.cast(this.orderTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LineItemCountsByStatus": {
                return Optional.ofNullable(clazz.cast(this.lineItemCountsByStatusAsStrings()));
            }
            case "OrderSubmissionDate": {
                return Optional.ofNullable(clazz.cast(this.orderSubmissionDate()));
            }
            case "OrderFulfilledDate": {
                return Optional.ofNullable(clazz.cast(this.orderFulfilledDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrderSummary, T> g) {
        return obj -> g.apply((OrderSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outpostId;
        private String orderId;
        private String orderType;
        private String status;
        private Map<String, Integer> lineItemCountsByStatus = DefaultSdkAutoConstructMap.getInstance();
        private Instant orderSubmissionDate;
        private Instant orderFulfilledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderSummary model) {
            this.outpostId(model.outpostId);
            this.orderId(model.orderId);
            this.orderType(model.orderType);
            this.status(model.status);
            this.lineItemCountsByStatusWithStrings(model.lineItemCountsByStatus);
            this.orderSubmissionDate(model.orderSubmissionDate);
            this.orderFulfilledDate(model.orderFulfilledDate);
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        @Transient
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOrderId() {
            return this.orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        @Transient
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final String getOrderType() {
            return this.orderType;
        }

        public final void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        @Override
        @Transient
        public final Builder orderType(String orderType) {
            this.orderType = orderType;
            return this;
        }

        @Override
        @Transient
        public final Builder orderType(OrderType orderType) {
            this.orderType(orderType == null ? null : orderType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(OrderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, Integer> getLineItemCountsByStatus() {
            if (this.lineItemCountsByStatus instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.lineItemCountsByStatus;
        }

        public final void setLineItemCountsByStatus(Map<String, Integer> lineItemCountsByStatus) {
            this.lineItemCountsByStatus = LineItemStatusCountsCopier.copy(lineItemCountsByStatus);
        }

        @Override
        @Transient
        public final Builder lineItemCountsByStatusWithStrings(Map<String, Integer> lineItemCountsByStatus) {
            this.lineItemCountsByStatus = LineItemStatusCountsCopier.copy(lineItemCountsByStatus);
            return this;
        }

        @Override
        @Transient
        public final Builder lineItemCountsByStatus(Map<LineItemStatus, Integer> lineItemCountsByStatus) {
            this.lineItemCountsByStatus = LineItemStatusCountsCopier.copyEnumToString(lineItemCountsByStatus);
            return this;
        }

        public final Instant getOrderSubmissionDate() {
            return this.orderSubmissionDate;
        }

        public final void setOrderSubmissionDate(Instant orderSubmissionDate) {
            this.orderSubmissionDate = orderSubmissionDate;
        }

        @Override
        @Transient
        public final Builder orderSubmissionDate(Instant orderSubmissionDate) {
            this.orderSubmissionDate = orderSubmissionDate;
            return this;
        }

        public final Instant getOrderFulfilledDate() {
            return this.orderFulfilledDate;
        }

        public final void setOrderFulfilledDate(Instant orderFulfilledDate) {
            this.orderFulfilledDate = orderFulfilledDate;
        }

        @Override
        @Transient
        public final Builder orderFulfilledDate(Instant orderFulfilledDate) {
            this.orderFulfilledDate = orderFulfilledDate;
            return this;
        }

        public OrderSummary build() {
            return new OrderSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrderSummary> {
        public Builder outpostId(String var1);

        public Builder orderId(String var1);

        public Builder orderType(String var1);

        public Builder orderType(OrderType var1);

        public Builder status(String var1);

        public Builder status(OrderStatus var1);

        public Builder lineItemCountsByStatusWithStrings(Map<String, Integer> var1);

        public Builder lineItemCountsByStatus(Map<LineItemStatus, Integer> var1);

        public Builder orderSubmissionDate(Instant var1);

        public Builder orderFulfilledDate(Instant var1);
    }
}

