/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOutpostsRequest extends OutpostsRequest implements
        ToCopyableBuilder<ListOutpostsRequest.Builder, ListOutpostsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOutpostsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListOutpostsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<List<String>> LIFE_CYCLE_STATUS_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LifeCycleStatusFilter")
            .getter(getter(ListOutpostsRequest::lifeCycleStatusFilter))
            .setter(setter(Builder::lifeCycleStatusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LifeCycleStatusFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONE_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZoneFilter")
            .getter(getter(ListOutpostsRequest::availabilityZoneFilter))
            .setter(setter(Builder::availabilityZoneFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AvailabilityZoneFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONE_ID_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZoneIdFilter")
            .getter(getter(ListOutpostsRequest::availabilityZoneIdFilter))
            .setter(setter(Builder::availabilityZoneIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AvailabilityZoneIdFilter")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LIFE_CYCLE_STATUS_FILTER_FIELD,
                    AVAILABILITY_ZONE_FILTER_FIELD, AVAILABILITY_ZONE_ID_FILTER_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> lifeCycleStatusFilter;

    private final List<String> availabilityZoneFilter;

    private final List<String> availabilityZoneIdFilter;

    private ListOutpostsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.lifeCycleStatusFilter = builder.lifeCycleStatusFilter;
        this.availabilityZoneFilter = builder.availabilityZoneFilter;
        this.availabilityZoneIdFilter = builder.availabilityZoneIdFilter;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifeCycleStatusFilter property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLifeCycleStatusFilter() {
        return lifeCycleStatusFilter != null && !(lifeCycleStatusFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter for the lifecycle status of the Outpost.
     * </p>
     * <p>
     * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
     * <code>OR</code>, and the request returns all results that match any of the specified values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifeCycleStatusFilter} method.
     * </p>
     * 
     * @return A filter for the lifecycle status of the Outpost. </p>
     *         <p>
     *         Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with
     *         an <code>OR</code>, and the request returns all results that match any of the specified values.
     */
    public final List<String> lifeCycleStatusFilter() {
        return lifeCycleStatusFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneFilter property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailabilityZoneFilter() {
        return availabilityZoneFilter != null && !(availabilityZoneFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost.
     * </p>
     * <p>
     * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
     * <code>OR</code>, and the request returns all results that match any of the specified values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneFilter} method.
     * </p>
     * 
     * @return A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
     *         <p>
     *         Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with
     *         an <code>OR</code>, and the request returns all results that match any of the specified values.
     */
    public final List<String> availabilityZoneFilter() {
        return availabilityZoneFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneIdFilter property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailabilityZoneIdFilter() {
        return availabilityZoneIdFilter != null && !(availabilityZoneIdFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost.
     * </p>
     * <p>
     * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
     * <code>OR</code>, and the request returns all results that match any of the specified values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneIdFilter} method.
     * </p>
     * 
     * @return A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
     *         <p>
     *         Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with
     *         an <code>OR</code>, and the request returns all results that match any of the specified values.
     */
    public final List<String> availabilityZoneIdFilter() {
        return availabilityZoneIdFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasLifeCycleStatusFilter() ? lifeCycleStatusFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneFilter() ? availabilityZoneFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneIdFilter() ? availabilityZoneIdFilter() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutpostsRequest)) {
            return false;
        }
        ListOutpostsRequest other = (ListOutpostsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasLifeCycleStatusFilter() == other.hasLifeCycleStatusFilter()
                && Objects.equals(lifeCycleStatusFilter(), other.lifeCycleStatusFilter())
                && hasAvailabilityZoneFilter() == other.hasAvailabilityZoneFilter()
                && Objects.equals(availabilityZoneFilter(), other.availabilityZoneFilter())
                && hasAvailabilityZoneIdFilter() == other.hasAvailabilityZoneIdFilter()
                && Objects.equals(availabilityZoneIdFilter(), other.availabilityZoneIdFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOutpostsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("LifeCycleStatusFilter", hasLifeCycleStatusFilter() ? lifeCycleStatusFilter() : null)
                .add("AvailabilityZoneFilter", hasAvailabilityZoneFilter() ? availabilityZoneFilter() : null)
                .add("AvailabilityZoneIdFilter", hasAvailabilityZoneIdFilter() ? availabilityZoneIdFilter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "LifeCycleStatusFilter":
            return Optional.ofNullable(clazz.cast(lifeCycleStatusFilter()));
        case "AvailabilityZoneFilter":
            return Optional.ofNullable(clazz.cast(availabilityZoneFilter()));
        case "AvailabilityZoneIdFilter":
            return Optional.ofNullable(clazz.cast(availabilityZoneIdFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOutpostsRequest, T> g) {
        return obj -> g.apply((ListOutpostsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOutpostsRequest> {
        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter for the lifecycle status of the Outpost.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param lifeCycleStatusFilter
         *        A filter for the lifecycle status of the Outpost. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStatusFilter(Collection<String> lifeCycleStatusFilter);

        /**
         * <p>
         * A filter for the lifecycle status of the Outpost.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param lifeCycleStatusFilter
         *        A filter for the lifecycle status of the Outpost. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStatusFilter(String... lifeCycleStatusFilter);

        /**
         * <p>
         * A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param availabilityZoneFilter
         *        A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneFilter(Collection<String> availabilityZoneFilter);

        /**
         * <p>
         * A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param availabilityZoneFilter
         *        A filter for the Availability Zone (<code>us-east-1a</code>) of the Outpost. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneFilter(String... availabilityZoneFilter);

        /**
         * <p>
         * A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param availabilityZoneIdFilter
         *        A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIdFilter(Collection<String> availabilityZoneIdFilter);

        /**
         * <p>
         * A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost.
         * </p>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param availabilityZoneIdFilter
         *        A filter for the AZ IDs (<code>use1-az1</code>) of the Outpost. </p>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIdFilter(String... availabilityZoneIdFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<String> lifeCycleStatusFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZoneFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZoneIdFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutpostsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            lifeCycleStatusFilter(model.lifeCycleStatusFilter);
            availabilityZoneFilter(model.availabilityZoneFilter);
            availabilityZoneIdFilter(model.availabilityZoneIdFilter);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getLifeCycleStatusFilter() {
            if (lifeCycleStatusFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return lifeCycleStatusFilter;
        }

        public final void setLifeCycleStatusFilter(Collection<String> lifeCycleStatusFilter) {
            this.lifeCycleStatusFilter = LifeCycleStatusListCopier.copy(lifeCycleStatusFilter);
        }

        @Override
        @Transient
        public final Builder lifeCycleStatusFilter(Collection<String> lifeCycleStatusFilter) {
            this.lifeCycleStatusFilter = LifeCycleStatusListCopier.copy(lifeCycleStatusFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lifeCycleStatusFilter(String... lifeCycleStatusFilter) {
            lifeCycleStatusFilter(Arrays.asList(lifeCycleStatusFilter));
            return this;
        }

        public final Collection<String> getAvailabilityZoneFilter() {
            if (availabilityZoneFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZoneFilter;
        }

        public final void setAvailabilityZoneFilter(Collection<String> availabilityZoneFilter) {
            this.availabilityZoneFilter = AvailabilityZoneListCopier.copy(availabilityZoneFilter);
        }

        @Override
        @Transient
        public final Builder availabilityZoneFilter(Collection<String> availabilityZoneFilter) {
            this.availabilityZoneFilter = AvailabilityZoneListCopier.copy(availabilityZoneFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZoneFilter(String... availabilityZoneFilter) {
            availabilityZoneFilter(Arrays.asList(availabilityZoneFilter));
            return this;
        }

        public final Collection<String> getAvailabilityZoneIdFilter() {
            if (availabilityZoneIdFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZoneIdFilter;
        }

        public final void setAvailabilityZoneIdFilter(Collection<String> availabilityZoneIdFilter) {
            this.availabilityZoneIdFilter = AvailabilityZoneIdListCopier.copy(availabilityZoneIdFilter);
        }

        @Override
        @Transient
        public final Builder availabilityZoneIdFilter(Collection<String> availabilityZoneIdFilter) {
            this.availabilityZoneIdFilter = AvailabilityZoneIdListCopier.copy(availabilityZoneIdFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZoneIdFilter(String... availabilityZoneIdFilter) {
            availabilityZoneIdFilter(Arrays.asList(availabilityZoneIdFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOutpostsRequest build() {
            return new ListOutpostsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
