/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Outpost.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Outpost implements SdkPojo, Serializable, ToCopyableBuilder<Outpost.Builder, Outpost> {
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(Outpost::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(Outpost::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn").getter(getter(Outpost::outpostArn)).setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()).build();

    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(Outpost::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Outpost::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Outpost::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LIFE_CYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifeCycleStatus").getter(getter(Outpost::lifeCycleStatus)).setter(setter(Builder::lifeCycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleStatus").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Outpost::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId").getter(getter(Outpost::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Outpost::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SiteArn").getter(getter(Outpost::siteArn)).setter(setter(Builder::siteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ID_FIELD,
            OWNER_ID_FIELD, OUTPOST_ARN_FIELD, SITE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LIFE_CYCLE_STATUS_FIELD,
            AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, TAGS_FIELD, SITE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outpostId;

    private final String ownerId;

    private final String outpostArn;

    private final String siteId;

    private final String name;

    private final String description;

    private final String lifeCycleStatus;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Map<String, String> tags;

    private final String siteArn;

    private Outpost(BuilderImpl builder) {
        this.outpostId = builder.outpostId;
        this.ownerId = builder.ownerId;
        this.outpostArn = builder.outpostArn;
        this.siteId = builder.siteId;
        this.name = builder.name;
        this.description = builder.description;
        this.lifeCycleStatus = builder.lifeCycleStatus;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tags = builder.tags;
        this.siteArn = builder.siteArn;
    }

    /**
     * Returns the value of the OutpostId property for this object.
     * 
     * @return The value of the OutpostId property for this object.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * Returns the value of the OwnerId property for this object.
     * 
     * @return The value of the OwnerId property for this object.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * Returns the value of the OutpostArn property for this object.
     * 
     * @return The value of the OutpostArn property for this object.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * Returns the value of the SiteId property for this object.
     * 
     * @return The value of the SiteId property for this object.
     */
    public final String siteId() {
        return siteId;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the LifeCycleStatus property for this object.
     * 
     * @return The value of the LifeCycleStatus property for this object.
     */
    public final String lifeCycleStatus() {
        return lifeCycleStatus;
    }

    /**
     * Returns the value of the AvailabilityZone property for this object.
     * 
     * @return The value of the AvailabilityZone property for this object.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * Returns the value of the AvailabilityZoneId property for this object.
     * 
     * @return The value of the AvailabilityZoneId property for this object.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Outpost tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Outpost tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns the value of the SiteArn property for this object.
     * 
     * @return The value of the SiteArn property for this object.
     */
    public final String siteArn() {
        return siteArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleStatus());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(siteArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Outpost)) {
            return false;
        }
        Outpost other = (Outpost) obj;
        return Objects.equals(outpostId(), other.outpostId()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(siteId(), other.siteId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(lifeCycleStatus(), other.lifeCycleStatus())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(siteArn(), other.siteArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Outpost").add("OutpostId", outpostId()).add("OwnerId", ownerId())
                .add("OutpostArn", outpostArn()).add("SiteId", siteId()).add("Name", name()).add("Description", description())
                .add("LifeCycleStatus", lifeCycleStatus()).add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("Tags", hasTags() ? tags() : null).add("SiteArn", siteArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LifeCycleStatus":
            return Optional.ofNullable(clazz.cast(lifeCycleStatus()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SiteArn":
            return Optional.ofNullable(clazz.cast(siteArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Outpost, T> g) {
        return obj -> g.apply((Outpost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Outpost> {
        /**
         * Sets the value of the OutpostId property for this object.
         *
         * @param outpostId
         *        The new value for the OutpostId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * Sets the value of the OwnerId property for this object.
         *
         * @param ownerId
         *        The new value for the OwnerId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * Sets the value of the OutpostArn property for this object.
         *
         * @param outpostArn
         *        The new value for the OutpostArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * Sets the value of the SiteId property for this object.
         *
         * @param siteId
         *        The new value for the SiteId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the LifeCycleStatus property for this object.
         *
         * @param lifeCycleStatus
         *        The new value for the LifeCycleStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStatus(String lifeCycleStatus);

        /**
         * Sets the value of the AvailabilityZone property for this object.
         *
         * @param availabilityZone
         *        The new value for the AvailabilityZone property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * Sets the value of the AvailabilityZoneId property for this object.
         *
         * @param availabilityZoneId
         *        The new value for the AvailabilityZoneId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The Outpost tags.
         * </p>
         * 
         * @param tags
         *        The Outpost tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Sets the value of the SiteArn property for this object.
         *
         * @param siteArn
         *        The new value for the SiteArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteArn(String siteArn);
    }

    static final class BuilderImpl implements Builder {
        private String outpostId;

        private String ownerId;

        private String outpostArn;

        private String siteId;

        private String name;

        private String description;

        private String lifeCycleStatus;

        private String availabilityZone;

        private String availabilityZoneId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String siteArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Outpost model) {
            outpostId(model.outpostId);
            ownerId(model.ownerId);
            outpostArn(model.outpostArn);
            siteId(model.siteId);
            name(model.name);
            description(model.description);
            lifeCycleStatus(model.lifeCycleStatus);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            tags(model.tags);
            siteArn(model.siteArn);
        }

        public final String getOutpostId() {
            return outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final String getSiteId() {
            return siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLifeCycleStatus() {
            return lifeCycleStatus;
        }

        @Override
        public final Builder lifeCycleStatus(String lifeCycleStatus) {
            this.lifeCycleStatus = lifeCycleStatus;
            return this;
        }

        public final void setLifeCycleStatus(String lifeCycleStatus) {
            this.lifeCycleStatus = lifeCycleStatus;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getSiteArn() {
            return siteArn;
        }

        @Override
        public final Builder siteArn(String siteArn) {
            this.siteArn = siteArn;
            return this;
        }

        public final void setSiteArn(String siteArn) {
            this.siteArn = siteArn;
        }

        @Override
        public Outpost build() {
            return new Outpost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
