/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOutpostResponse extends OutpostsResponse implements
        ToCopyableBuilder<GetOutpostResponse.Builder, GetOutpostResponse> {
    private static final SdkField<Outpost> OUTPOST_FIELD = SdkField.<Outpost> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetOutpostResponse::outpost)).setter(setter(Builder::outpost)).constructor(Outpost::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outpost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_FIELD));

    private final Outpost outpost;

    private GetOutpostResponse(BuilderImpl builder) {
        super(builder);
        this.outpost = builder.outpost;
    }

    /**
     * Returns the value of the Outpost property for this object.
     * 
     * @return The value of the Outpost property for this object.
     */
    public Outpost outpost() {
        return outpost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpost());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutpostResponse)) {
            return false;
        }
        GetOutpostResponse other = (GetOutpostResponse) obj;
        return Objects.equals(outpost(), other.outpost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOutpostResponse").add("Outpost", outpost()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Outpost":
            return Optional.ofNullable(clazz.cast(outpost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOutpostResponse, T> g) {
        return obj -> g.apply((GetOutpostResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOutpostResponse> {
        /**
         * Sets the value of the Outpost property for this object.
         *
         * @param outpost
         *        The new value for the Outpost property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpost(Outpost outpost);

        /**
         * Sets the value of the Outpost property for this object.
         *
         * This is a convenience that creates an instance of the {@link Outpost.Builder} avoiding the need to create one
         * manually via {@link Outpost#builder()}.
         *
         * When the {@link Consumer} completes, {@link Outpost.Builder#build()} is called immediately and its result is
         * passed to {@link #outpost(Outpost)}.
         * 
         * @param outpost
         *        a consumer that will call methods on {@link Outpost.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outpost(Outpost)
         */
        default Builder outpost(Consumer<Outpost.Builder> outpost) {
            return outpost(Outpost.builder().applyMutation(outpost).build());
        }
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private Outpost outpost;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutpostResponse model) {
            super(model);
            outpost(model.outpost);
        }

        public final Outpost.Builder getOutpost() {
            return outpost != null ? outpost.toBuilder() : null;
        }

        @Override
        public final Builder outpost(Outpost outpost) {
            this.outpost = outpost;
            return this;
        }

        public final void setOutpost(Outpost.BuilderImpl outpost) {
            this.outpost = outpost != null ? outpost.build() : null;
        }

        @Override
        public GetOutpostResponse build() {
            return new GetOutpostResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
