/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.ActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HandshakeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HandshakeFilter> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(HandshakeFilter.getter(HandshakeFilter::actionTypeAsString)).setter(HandshakeFilter.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> PARENT_HANDSHAKE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentHandshakeId").getter(HandshakeFilter.getter(HandshakeFilter::parentHandshakeId)).setter(HandshakeFilter.setter(Builder::parentHandshakeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentHandshakeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, PARENT_HANDSHAKE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HandshakeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionType;
    private final String parentHandshakeId;

    private HandshakeFilter(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.parentHandshakeId = builder.parentHandshakeId;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final String parentHandshakeId() {
        return this.parentHandshakeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentHandshakeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeFilter)) {
            return false;
        }
        HandshakeFilter other = (HandshakeFilter)obj;
        return Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.parentHandshakeId(), other.parentHandshakeId());
    }

    public final String toString() {
        return ToString.builder((String)"HandshakeFilter").add("ActionType", (Object)this.actionTypeAsString()).add("ParentHandshakeId", (Object)this.parentHandshakeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "ParentHandshakeId": {
                return Optional.ofNullable(clazz.cast(this.parentHandshakeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("ParentHandshakeId", PARENT_HANDSHAKE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HandshakeFilter, T> g) {
        return obj -> g.apply((HandshakeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private String parentHandshakeId;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeFilter model) {
            this.actionType(model.actionType);
            this.parentHandshakeId(model.parentHandshakeId);
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getParentHandshakeId() {
            return this.parentHandshakeId;
        }

        public final void setParentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
        }

        @Override
        public final Builder parentHandshakeId(String parentHandshakeId) {
            this.parentHandshakeId = parentHandshakeId;
            return this;
        }

        public HandshakeFilter build() {
            return new HandshakeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HandshakeFilter> {
        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder parentHandshakeId(String var1);
    }
}

