/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest;
import software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse;

public class ListOrganizationalUnitsForParentIterable
implements SdkIterable<ListOrganizationalUnitsForParentResponse> {
    private final OrganizationsClient client;
    private final ListOrganizationalUnitsForParentRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationalUnitsForParentIterable(OrganizationsClient client, ListOrganizationalUnitsForParentRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOrganizationalUnitsForParentResponseFetcher();
    }

    public Iterator<ListOrganizationalUnitsForParentResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListOrganizationalUnitsForParentResponseFetcher
    implements SyncPageFetcher<ListOrganizationalUnitsForParentResponse> {
        private ListOrganizationalUnitsForParentResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationalUnitsForParentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrganizationalUnitsForParentResponse nextPage(ListOrganizationalUnitsForParentResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationalUnitsForParentIterable.this.client.listOrganizationalUnitsForParent(ListOrganizationalUnitsForParentIterable.this.firstRequest);
            }
            return ListOrganizationalUnitsForParentIterable.this.client.listOrganizationalUnitsForParent((ListOrganizationalUnitsForParentRequest)((Object)ListOrganizationalUnitsForParentIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

