/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyType {
    SERVICE_CONTROL_POLICY("SERVICE_CONTROL_POLICY"),
    RESOURCE_CONTROL_POLICY("RESOURCE_CONTROL_POLICY"),
    TAG_POLICY("TAG_POLICY"),
    BACKUP_POLICY("BACKUP_POLICY"),
    AISERVICES_OPT_OUT_POLICY("AISERVICES_OPT_OUT_POLICY"),
    CHATBOT_POLICY("CHATBOT_POLICY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyType> VALUE_MAP;
    private final String value;

    private PolicyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyType> knownValues() {
        EnumSet<PolicyType> knownValues = EnumSet.allOf(PolicyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyType.class, PolicyType::toString);
    }
}

