/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.ElasticIp;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticIpMarshaller {
    private static final MarshallingInfo<String> IP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ip").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domain").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final ElasticIpMarshaller INSTANCE = new ElasticIpMarshaller();

    private ElasticIpMarshaller() {
    }

    public static ElasticIpMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticIp elasticIp, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticIp, (String)"elasticIp");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticIp.ip(), IP_BINDING);
            protocolMarshaller.marshall((Object)elasticIp.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)elasticIp.domain(), DOMAIN_BINDING);
            protocolMarshaller.marshall((Object)elasticIp.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)elasticIp.instanceId(), INSTANCEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

