/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteInstanceRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DeleteInstanceRequest> {
    private final String instanceId;
    private final Boolean deleteElasticIp;
    private final Boolean deleteVolumes;

    private DeleteInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.deleteElasticIp = builder.deleteElasticIp;
        this.deleteVolumes = builder.deleteVolumes;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean deleteElasticIp() {
        return this.deleteElasticIp;
    }

    public Boolean deleteVolumes() {
        return this.deleteVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteElasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteVolumes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceRequest)) {
            return false;
        }
        DeleteInstanceRequest other = (DeleteInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.deleteElasticIp(), other.deleteElasticIp()) && Objects.equals(this.deleteVolumes(), other.deleteVolumes());
    }

    public String toString() {
        return ToString.builder((String)"DeleteInstanceRequest").add("InstanceId", (Object)this.instanceId()).add("DeleteElasticIp", (Object)this.deleteElasticIp()).add("DeleteVolumes", (Object)this.deleteVolumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "DeleteElasticIp": {
                return Optional.of(clazz.cast(this.deleteElasticIp()));
            }
            case "DeleteVolumes": {
                return Optional.of(clazz.cast(this.deleteVolumes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean deleteElasticIp;
        private Boolean deleteVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceRequest model) {
            this.instanceId(model.instanceId);
            this.deleteElasticIp(model.deleteElasticIp);
            this.deleteVolumes(model.deleteVolumes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getDeleteElasticIp() {
            return this.deleteElasticIp;
        }

        @Override
        public final Builder deleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
            return this;
        }

        public final void setDeleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
        }

        public final Boolean getDeleteVolumes() {
            return this.deleteVolumes;
        }

        @Override
        public final Builder deleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
            return this;
        }

        public final void setDeleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteInstanceRequest build() {
            return new DeleteInstanceRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DeleteInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder deleteElasticIp(Boolean var1);

        public Builder deleteVolumes(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

