/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.WeeklyAutoScalingSchedule;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link WeeklyAutoScalingSchedule} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class WeeklyAutoScalingScheduleMarshaller {
    private static final MarshallingInfo<Map> MONDAY_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Monday").isBinary(false).build();

    private static final MarshallingInfo<Map> TUESDAY_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tuesday").isBinary(false).build();

    private static final MarshallingInfo<Map> WEDNESDAY_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Wednesday").isBinary(false).build();

    private static final MarshallingInfo<Map> THURSDAY_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Thursday").isBinary(false).build();

    private static final MarshallingInfo<Map> FRIDAY_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Friday").isBinary(false).build();

    private static final MarshallingInfo<Map> SATURDAY_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Saturday").isBinary(false).build();

    private static final MarshallingInfo<Map> SUNDAY_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sunday").isBinary(false).build();

    private static final WeeklyAutoScalingScheduleMarshaller INSTANCE = new WeeklyAutoScalingScheduleMarshaller();

    private WeeklyAutoScalingScheduleMarshaller() {
    }

    public static WeeklyAutoScalingScheduleMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(WeeklyAutoScalingSchedule weeklyAutoScalingSchedule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(weeklyAutoScalingSchedule, "weeklyAutoScalingSchedule");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(weeklyAutoScalingSchedule.monday(), MONDAY_BINDING);
            protocolMarshaller.marshall(weeklyAutoScalingSchedule.tuesday(), TUESDAY_BINDING);
            protocolMarshaller.marshall(weeklyAutoScalingSchedule.wednesday(), WEDNESDAY_BINDING);
            protocolMarshaller.marshall(weeklyAutoScalingSchedule.thursday(), THURSDAY_BINDING);
            protocolMarshaller.marshall(weeklyAutoScalingSchedule.friday(), FRIDAY_BINDING);
            protocolMarshaller.marshall(weeklyAutoScalingSchedule.saturday(), SATURDAY_BINDING);
            protocolMarshaller.marshall(weeklyAutoScalingSchedule.sunday(), SUNDAY_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
