/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.UpdateInstanceRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateInstanceRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateInstanceRequestModelMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();

    private static final MarshallingInfo<List> LAYERIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerIds").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();

    private static final MarshallingInfo<String> AUTOSCALINGTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingType").isBinary(false).build();

    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").isBinary(false).build();

    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Os").isBinary(false).build();

    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").isBinary(false).build();

    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshKeyName").isBinary(false).build();

    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").isBinary(false).build();

    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").isBinary(false).build();

    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();

    private static final UpdateInstanceRequestModelMarshaller INSTANCE = new UpdateInstanceRequestModelMarshaller();

    private UpdateInstanceRequestModelMarshaller() {
    }

    public static UpdateInstanceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateInstanceRequest updateInstanceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateInstanceRequest, "updateInstanceRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateInstanceRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.layerIds(), LAYERIDS_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.autoScalingTypeString(), AUTOSCALINGTYPE_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.os(), OS_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.sshKeyName(), SSHKEYNAME_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.architectureString(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.ebsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall(updateInstanceRequest.agentVersion(), AGENTVERSION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
