/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.LoadBasedAutoScalingConfiguration;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link LoadBasedAutoScalingConfiguration} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class LoadBasedAutoScalingConfigurationMarshaller {
    private static final MarshallingInfo<String> LAYERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerId").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ENABLE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enable").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> UPSCALING_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpScaling").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DOWNSCALING_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DownScaling")
            .isBinary(false).build();

    private static final LoadBasedAutoScalingConfigurationMarshaller INSTANCE = new LoadBasedAutoScalingConfigurationMarshaller();

    private LoadBasedAutoScalingConfigurationMarshaller() {
    }

    public static LoadBasedAutoScalingConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(LoadBasedAutoScalingConfiguration loadBasedAutoScalingConfiguration,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(loadBasedAutoScalingConfiguration, "loadBasedAutoScalingConfiguration");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(loadBasedAutoScalingConfiguration.layerId(), LAYERID_BINDING);
            protocolMarshaller.marshall(loadBasedAutoScalingConfiguration.enable(), ENABLE_BINDING);
            protocolMarshaller.marshall(loadBasedAutoScalingConfiguration.upScaling(), UPSCALING_BINDING);
            protocolMarshaller.marshall(loadBasedAutoScalingConfiguration.downScaling(), DOWNSCALING_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
