/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateRdsDbInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<UpdateRdsDbInstanceRequest.Builder, UpdateRdsDbInstanceRequest> {
    private final String rdsDbInstanceArn;

    private final String dbUser;

    private final String dbPassword;

    private UpdateRdsDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
    }

    /**
     * <p>
     * The Amazon RDS instance's ARN.
     * </p>
     * 
     * @return The Amazon RDS instance's ARN.
     */
    public String rdsDbInstanceArn() {
        return rdsDbInstanceArn;
    }

    /**
     * <p>
     * The master user name.
     * </p>
     * 
     * @return The master user name.
     */
    public String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The database password.
     * </p>
     * 
     * @return The database password.
     */
    public String dbPassword() {
        return dbPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(dbPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRdsDbInstanceRequest)) {
            return false;
        }
        UpdateRdsDbInstanceRequest other = (UpdateRdsDbInstanceRequest) obj;
        return Objects.equals(rdsDbInstanceArn(), other.rdsDbInstanceArn()) && Objects.equals(dbUser(), other.dbUser())
                && Objects.equals(dbPassword(), other.dbPassword());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateRdsDbInstanceRequest").add("RdsDbInstanceArn", rdsDbInstanceArn()).add("DbUser", dbUser())
                .add("DbPassword", dbPassword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RdsDbInstanceArn":
            return Optional.of(clazz.cast(rdsDbInstanceArn()));
        case "DbUser":
            return Optional.of(clazz.cast(dbUser()));
        case "DbPassword":
            return Optional.of(clazz.cast(dbPassword()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, UpdateRdsDbInstanceRequest> {
        /**
         * <p>
         * The Amazon RDS instance's ARN.
         * </p>
         * 
         * @param rdsDbInstanceArn
         *        The Amazon RDS instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArn(String rdsDbInstanceArn);

        /**
         * <p>
         * The master user name.
         * </p>
         * 
         * @param dbUser
         *        The master user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The database password.
         * </p>
         * 
         * @param dbPassword
         *        The database password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String rdsDbInstanceArn;

        private String dbUser;

        private String dbPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRdsDbInstanceRequest model) {
            rdsDbInstanceArn(model.rdsDbInstanceArn);
            dbUser(model.dbUser);
            dbPassword(model.dbPassword);
        }

        public final String getRdsDbInstanceArn() {
            return rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateRdsDbInstanceRequest build() {
            return new UpdateRdsDbInstanceRequest(this);
        }
    }
}
