/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ElasticLoadBalancerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Elastic Load Balancing instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticLoadBalancer implements StructuredPojo, ToCopyableBuilder<ElasticLoadBalancer.Builder, ElasticLoadBalancer> {
    private final String elasticLoadBalancerName;

    private final String region;

    private final String dnsName;

    private final String stackId;

    private final String layerId;

    private final String vpcId;

    private final List<String> availabilityZones;

    private final List<String> subnetIds;

    private final List<String> ec2InstanceIds;

    private ElasticLoadBalancer(BuilderImpl builder) {
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.region = builder.region;
        this.dnsName = builder.dnsName;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.vpcId = builder.vpcId;
        this.availabilityZones = builder.availabilityZones;
        this.subnetIds = builder.subnetIds;
        this.ec2InstanceIds = builder.ec2InstanceIds;
    }

    /**
     * <p>
     * The Elastic Load Balancing instance's name.
     * </p>
     * 
     * @return The Elastic Load Balancing instance's name.
     */
    public String elasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * <p>
     * The instance's AWS region.
     * </p>
     * 
     * @return The instance's AWS region.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The instance's public DNS name.
     * </p>
     * 
     * @return The instance's public DNS name.
     */
    public String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The ID of the stack that the instance is associated with.
     * </p>
     * 
     * @return The ID of the stack that the instance is associated with.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The ID of the layer that the instance is attached to.
     * </p>
     * 
     * @return The ID of the layer that the instance is attached to.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * The VPC ID.
     * </p>
     * 
     * @return The VPC ID.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * A list of Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of Availability Zones.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * A list of subnet IDs, if the stack is running in a VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of subnet IDs, if the stack is running in a VPC.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
     */
    public List<String> ec2InstanceIds() {
        return ec2InstanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticLoadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticLoadBalancer)) {
            return false;
        }
        ElasticLoadBalancer other = (ElasticLoadBalancer) obj;
        return Objects.equals(elasticLoadBalancerName(), other.elasticLoadBalancerName())
                && Objects.equals(region(), other.region()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(stackId(), other.stackId()) && Objects.equals(layerId(), other.layerId())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(ec2InstanceIds(), other.ec2InstanceIds());
    }

    @Override
    public String toString() {
        return ToString.builder("ElasticLoadBalancer").add("ElasticLoadBalancerName", elasticLoadBalancerName())
                .add("Region", region()).add("DnsName", dnsName()).add("StackId", stackId()).add("LayerId", layerId())
                .add("VpcId", vpcId()).add("AvailabilityZones", availabilityZones()).add("SubnetIds", subnetIds())
                .add("Ec2InstanceIds", ec2InstanceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticLoadBalancerName":
            return Optional.of(clazz.cast(elasticLoadBalancerName()));
        case "Region":
            return Optional.of(clazz.cast(region()));
        case "DnsName":
            return Optional.of(clazz.cast(dnsName()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "LayerId":
            return Optional.of(clazz.cast(layerId()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        case "AvailabilityZones":
            return Optional.of(clazz.cast(availabilityZones()));
        case "SubnetIds":
            return Optional.of(clazz.cast(subnetIds()));
        case "Ec2InstanceIds":
            return Optional.of(clazz.cast(ec2InstanceIds()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticLoadBalancerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticLoadBalancer> {
        /**
         * <p>
         * The Elastic Load Balancing instance's name.
         * </p>
         * 
         * @param elasticLoadBalancerName
         *        The Elastic Load Balancing instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancerName(String elasticLoadBalancerName);

        /**
         * <p>
         * The instance's AWS region.
         * </p>
         * 
         * @param region
         *        The instance's AWS region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The instance's public DNS name.
         * </p>
         * 
         * @param dnsName
         *        The instance's public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The ID of the stack that the instance is associated with.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack that the instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The ID of the layer that the instance is attached to.
         * </p>
         * 
         * @param layerId
         *        The ID of the layer that the instance is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * The VPC ID.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * A list of subnet IDs, if the stack is running in a VPC.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs, if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs, if the stack is running in a VPC.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs, if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * </p>
         * 
         * @param ec2InstanceIds
         *        A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceIds(Collection<String> ec2InstanceIds);

        /**
         * <p>
         * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * </p>
         * 
         * @param ec2InstanceIds
         *        A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceIds(String... ec2InstanceIds);
    }

    static final class BuilderImpl implements Builder {
        private String elasticLoadBalancerName;

        private String region;

        private String dnsName;

        private String stackId;

        private String layerId;

        private String vpcId;

        private List<String> availabilityZones;

        private List<String> subnetIds;

        private List<String> ec2InstanceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticLoadBalancer model) {
            elasticLoadBalancerName(model.elasticLoadBalancerName);
            region(model.region);
            dnsName(model.dnsName);
            stackId(model.stackId);
            layerId(model.layerId);
            vpcId(model.vpcId);
            availabilityZones(model.availabilityZones);
            subnetIds(model.subnetIds);
            ec2InstanceIds(model.ec2InstanceIds);
        }

        public final String getElasticLoadBalancerName() {
            return elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getDnsName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final Collection<String> getEc2InstanceIds() {
            return ec2InstanceIds;
        }

        @Override
        public final Builder ec2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceIds(String... ec2InstanceIds) {
            ec2InstanceIds(Arrays.asList(ec2InstanceIds));
            return this;
        }

        public final void setEc2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
        }

        @Override
        public ElasticLoadBalancer build() {
            return new ElasticLoadBalancer(this);
        }
    }
}
