/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeCommands</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCommandsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeCommandsResponse.Builder, DescribeCommandsResponse> {
    private final List<Command> commands;

    private DescribeCommandsResponse(BuilderImpl builder) {
        super(builder);
        this.commands = builder.commands;
    }

    /**
     * <p>
     * An array of <code>Command</code> objects that describe each of the specified commands.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Command</code> objects that describe each of the specified commands.
     */
    public List<Command> commands() {
        return commands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commands());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsResponse)) {
            return false;
        }
        DescribeCommandsResponse other = (DescribeCommandsResponse) obj;
        return Objects.equals(commands(), other.commands());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeCommandsResponse").add("Commands", commands()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Commands":
            return Optional.of(clazz.cast(commands()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeCommandsResponse> {
        /**
         * <p>
         * An array of <code>Command</code> objects that describe each of the specified commands.
         * </p>
         * 
         * @param commands
         *        An array of <code>Command</code> objects that describe each of the specified commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Collection<Command> commands);

        /**
         * <p>
         * An array of <code>Command</code> objects that describe each of the specified commands.
         * </p>
         * 
         * @param commands
         *        An array of <code>Command</code> objects that describe each of the specified commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Command... commands);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Command> commands;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsResponse model) {
            commands(model.commands);
        }

        public final Collection<Command.Builder> getCommands() {
            return commands != null ? commands.stream().map(Command::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandsCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command... commands) {
            commands(Arrays.asList(commands));
            return this;
        }

        public final void setCommands(Collection<Command.BuilderImpl> commands) {
            this.commands = CommandsCopier.copyFromBuilder(commands);
        }

        @Override
        public DescribeCommandsResponse build() {
            return new DescribeCommandsResponse(this);
        }
    }
}
