/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AutoScalingType {
    LOAD("load"),
    TIMER("timer"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AutoScalingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoScalingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AutoScalingType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoScalingType> knownValues() {
        return Stream.of(AutoScalingType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

