/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ReportedOsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A registered instance's reported operating system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReportedOs implements StructuredPojo, ToCopyableBuilder<ReportedOs.Builder, ReportedOs> {
    private final String family;

    private final String name;

    private final String version;

    private ReportedOs(BuilderImpl builder) {
        this.family = builder.family;
        this.name = builder.name;
        this.version = builder.version;
    }

    /**
     * <p>
     * The operating system family.
     * </p>
     * 
     * @return The operating system family.
     */
    public String family() {
        return family;
    }

    /**
     * <p>
     * The operating system name.
     * </p>
     * 
     * @return The operating system name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The operating system version.
     * </p>
     * 
     * @return The operating system version.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportedOs)) {
            return false;
        }
        ReportedOs other = (ReportedOs) obj;
        return Objects.equals(family(), other.family()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        return ToString.builder("ReportedOs").add("Family", family()).add("Name", name()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Family":
            return Optional.of(clazz.cast(family()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Version":
            return Optional.of(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportedOsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReportedOs> {
        /**
         * <p>
         * The operating system family.
         * </p>
         * 
         * @param family
         *        The operating system family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The operating system name.
         * </p>
         * 
         * @param name
         *        The operating system name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The operating system version.
         * </p>
         * 
         * @param version
         *        The operating system version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String family;

        private String name;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportedOs model) {
            family(model.family);
            name(model.name);
            version(model.version);
        }

        public final String getFamily() {
            return family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public ReportedOs build() {
            return new ReportedOs(this);
        }
    }
}
