/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.RdsDbInstanceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon RDS instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RdsDbInstance implements StructuredPojo, ToCopyableBuilder<RdsDbInstance.Builder, RdsDbInstance> {
    private final String rdsDbInstanceArn;

    private final String dbInstanceIdentifier;

    private final String dbUser;

    private final String dbPassword;

    private final String region;

    private final String address;

    private final String engine;

    private final String stackId;

    private final Boolean missingOnRds;

    private RdsDbInstance(BuilderImpl builder) {
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
        this.region = builder.region;
        this.address = builder.address;
        this.engine = builder.engine;
        this.stackId = builder.stackId;
        this.missingOnRds = builder.missingOnRds;
    }

    /**
     * <p>
     * The instance's ARN.
     * </p>
     * 
     * @return The instance's ARN.
     */
    public String rdsDbInstanceArn() {
        return rdsDbInstanceArn;
    }

    /**
     * <p>
     * The DB instance identifier.
     * </p>
     * 
     * @return The DB instance identifier.
     */
    public String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The master user name.
     * </p>
     * 
     * @return The master user name.
     */
    public String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
     * </p>
     * 
     * @return AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
     */
    public String dbPassword() {
        return dbPassword;
    }

    /**
     * <p>
     * The instance's AWS region.
     * </p>
     * 
     * @return The instance's AWS region.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The instance's address.
     * </p>
     * 
     * @return The instance's address.
     */
    public String address() {
        return address;
    }

    /**
     * <p>
     * The instance's database engine.
     * </p>
     * 
     * @return The instance's database engine.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The ID of the stack with which the instance is registered.
     * </p>
     * 
     * @return The ID of the stack with which the instance is registered.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * Set to <code>true</code> if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS OpsWorks
     * Stacks attempts to discover the instance only once. If this value is set to <code>true</code>, you must
     * deregister the instance, and then register it again.
     * </p>
     * 
     * @return Set to <code>true</code> if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS
     *         OpsWorks Stacks attempts to discover the instance only once. If this value is set to <code>true</code>,
     *         you must deregister the instance, and then register it again.
     */
    public Boolean missingOnRds() {
        return missingOnRds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(missingOnRds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbInstance)) {
            return false;
        }
        RdsDbInstance other = (RdsDbInstance) obj;
        return Objects.equals(rdsDbInstanceArn(), other.rdsDbInstanceArn())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbUser(), other.dbUser()) && Objects.equals(dbPassword(), other.dbPassword())
                && Objects.equals(region(), other.region()) && Objects.equals(address(), other.address())
                && Objects.equals(engine(), other.engine()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(missingOnRds(), other.missingOnRds());
    }

    @Override
    public String toString() {
        return ToString.builder("RdsDbInstance").add("RdsDbInstanceArn", rdsDbInstanceArn())
                .add("DbInstanceIdentifier", dbInstanceIdentifier()).add("DbUser", dbUser()).add("DbPassword", dbPassword())
                .add("Region", region()).add("Address", address()).add("Engine", engine()).add("StackId", stackId())
                .add("MissingOnRds", missingOnRds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RdsDbInstanceArn":
            return Optional.of(clazz.cast(rdsDbInstanceArn()));
        case "DbInstanceIdentifier":
            return Optional.of(clazz.cast(dbInstanceIdentifier()));
        case "DbUser":
            return Optional.of(clazz.cast(dbUser()));
        case "DbPassword":
            return Optional.of(clazz.cast(dbPassword()));
        case "Region":
            return Optional.of(clazz.cast(region()));
        case "Address":
            return Optional.of(clazz.cast(address()));
        case "Engine":
            return Optional.of(clazz.cast(engine()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "MissingOnRds":
            return Optional.of(clazz.cast(missingOnRds()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RdsDbInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RdsDbInstance> {
        /**
         * <p>
         * The instance's ARN.
         * </p>
         * 
         * @param rdsDbInstanceArn
         *        The instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArn(String rdsDbInstanceArn);

        /**
         * <p>
         * The DB instance identifier.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The DB instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The master user name.
         * </p>
         * 
         * @param dbUser
         *        The master user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
         * </p>
         * 
         * @param dbPassword
         *        AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);

        /**
         * <p>
         * The instance's AWS region.
         * </p>
         * 
         * @param region
         *        The instance's AWS region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The instance's address.
         * </p>
         * 
         * @param address
         *        The instance's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The instance's database engine.
         * </p>
         * 
         * @param engine
         *        The instance's database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The ID of the stack with which the instance is registered.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack with which the instance is registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * Set to <code>true</code> if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS OpsWorks
         * Stacks attempts to discover the instance only once. If this value is set to <code>true</code>, you must
         * deregister the instance, and then register it again.
         * </p>
         * 
         * @param missingOnRds
         *        Set to <code>true</code> if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS
         *        OpsWorks Stacks attempts to discover the instance only once. If this value is set to <code>true</code>
         *        , you must deregister the instance, and then register it again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingOnRds(Boolean missingOnRds);
    }

    static final class BuilderImpl implements Builder {
        private String rdsDbInstanceArn;

        private String dbInstanceIdentifier;

        private String dbUser;

        private String dbPassword;

        private String region;

        private String address;

        private String engine;

        private String stackId;

        private Boolean missingOnRds;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbInstance model) {
            rdsDbInstanceArn(model.rdsDbInstanceArn);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbUser(model.dbUser);
            dbPassword(model.dbPassword);
            region(model.region);
            address(model.address);
            engine(model.engine);
            stackId(model.stackId);
            missingOnRds(model.missingOnRds);
        }

        public final String getRdsDbInstanceArn() {
            return rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Boolean getMissingOnRds() {
            return missingOnRds;
        }

        @Override
        public final Builder missingOnRds(Boolean missingOnRds) {
            this.missingOnRds = missingOnRds;
            return this;
        }

        public final void setMissingOnRds(Boolean missingOnRds) {
            this.missingOnRds = missingOnRds;
        }

        @Override
        public RdsDbInstance build() {
            return new RdsDbInstance(this);
        }
    }
}
