/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>ListTags</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsResponse extends OpsWorksResponse implements ToCopyableBuilder<ListTagsResponse.Builder, ListTagsResponse> {
    private final Map<String, String> tags;

    private final String nextToken;

    private ListTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A set of key-value pairs that contain tag keys and tag values that are attached to a stack or layer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of key-value pairs that contain tag keys and tag values that are attached to a stack or layer.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * If a paginated request does not return all of the remaining results, this parameter is set to a token that you
     * can assign to the request object's <code>NextToken</code> parameter to get the next set of results. If the
     * previous paginated request returned all of the remaining results, this parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If a paginated request does not return all of the remaining results, this parameter is set to a token
     *         that you can assign to the request object's <code>NextToken</code> parameter to get the next set of
     *         results. If the previous paginated request returned all of the remaining results, this parameter is set
     *         to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsResponse)) {
            return false;
        }
        ListTagsResponse other = (ListTagsResponse) obj;
        return Objects.equals(tags(), other.tags()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsResponse").add("Tags", tags()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, ListTagsResponse> {
        /**
         * <p>
         * A set of key-value pairs that contain tag keys and tag values that are attached to a stack or layer.
         * </p>
         * 
         * @param tags
         *        A set of key-value pairs that contain tag keys and tag values that are attached to a stack or layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * If a paginated request does not return all of the remaining results, this parameter is set to a token that
         * you can assign to the request object's <code>NextToken</code> parameter to get the next set of results. If
         * the previous paginated request returned all of the remaining results, this parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If a paginated request does not return all of the remaining results, this parameter is set to a token
         *        that you can assign to the request object's <code>NextToken</code> parameter to get the next set of
         *        results. If the previous paginated request returned all of the remaining results, this parameter is
         *        set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private Map<String, String> tags;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsResponse model) {
            tags(model.tags);
            nextToken(model.nextToken);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTagsResponse build() {
            return new ListTagsResponse(this);
        }
    }
}
