/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeVolumes</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumesResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeVolumesResponse.Builder, DescribeVolumesResponse> {
    private final List<Volume> volumes;

    private DescribeVolumesResponse(BuilderImpl builder) {
        super(builder);
        this.volumes = builder.volumes;
    }

    /**
     * <p>
     * An array of volume IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of volume IDs.
     */
    public List<Volume> volumes() {
        return volumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesResponse)) {
            return false;
        }
        DescribeVolumesResponse other = (DescribeVolumesResponse) obj;
        return Objects.equals(volumes(), other.volumes());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVolumesResponse").add("Volumes", volumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Volumes":
            return Optional.of(clazz.cast(volumes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeVolumesResponse> {
        /**
         * <p>
         * An array of volume IDs.
         * </p>
         * 
         * @param volumes
         *        An array of volume IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * An array of volume IDs.
         * </p>
         * 
         * @param volumes
         *        An array of volume IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Volume> volumes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesResponse model) {
            volumes(model.volumes);
        }

        public final Collection<Volume.Builder> getVolumes() {
            return volumes != null ? volumes.stream().map(Volume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public DescribeVolumesResponse build() {
            return new DescribeVolumesResponse(this);
        }
    }
}
