/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeLoadBasedAutoScaling</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLoadBasedAutoScalingResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeLoadBasedAutoScalingResponse.Builder, DescribeLoadBasedAutoScalingResponse> {
    private final List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations;

    private DescribeLoadBasedAutoScalingResponse(BuilderImpl builder) {
        super(builder);
        this.loadBasedAutoScalingConfigurations = builder.loadBasedAutoScalingConfigurations;
    }

    /**
     * <p>
     * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
     *         configuration.
     */
    public List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations() {
        return loadBasedAutoScalingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBasedAutoScalingConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBasedAutoScalingResponse)) {
            return false;
        }
        DescribeLoadBasedAutoScalingResponse other = (DescribeLoadBasedAutoScalingResponse) obj;
        return Objects.equals(loadBasedAutoScalingConfigurations(), other.loadBasedAutoScalingConfigurations());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeLoadBasedAutoScalingResponse")
                .add("LoadBasedAutoScalingConfigurations", loadBasedAutoScalingConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBasedAutoScalingConfigurations":
            return Optional.of(clazz.cast(loadBasedAutoScalingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeLoadBasedAutoScalingResponse> {
        /**
         * <p>
         * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
         * </p>
         * 
         * @param loadBasedAutoScalingConfigurations
         *        An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations);

        /**
         * <p>
         * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
         * </p>
         * 
         * @param loadBasedAutoScalingConfigurations
         *        An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBasedAutoScalingConfigurations(LoadBasedAutoScalingConfiguration... loadBasedAutoScalingConfigurations);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBasedAutoScalingResponse model) {
            loadBasedAutoScalingConfigurations(model.loadBasedAutoScalingConfigurations);
        }

        public final Collection<LoadBasedAutoScalingConfiguration.Builder> getLoadBasedAutoScalingConfigurations() {
            return loadBasedAutoScalingConfigurations != null ? loadBasedAutoScalingConfigurations.stream()
                    .map(LoadBasedAutoScalingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations = LoadBasedAutoScalingConfigurationsCopier
                    .copy(loadBasedAutoScalingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBasedAutoScalingConfigurations(
                LoadBasedAutoScalingConfiguration... loadBasedAutoScalingConfigurations) {
            loadBasedAutoScalingConfigurations(Arrays.asList(loadBasedAutoScalingConfigurations));
            return this;
        }

        public final void setLoadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration.BuilderImpl> loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations = LoadBasedAutoScalingConfigurationsCopier
                    .copyFromBuilder(loadBasedAutoScalingConfigurations);
        }

        @Override
        public DescribeLoadBasedAutoScalingResponse build() {
            return new DescribeLoadBasedAutoScalingResponse(this);
        }
    }
}
