/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAppsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeAppsRequest.Builder, DescribeAppsRequest> {
    private final String stackId;

    private final List<String> appIds;

    private DescribeAppsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.appIds = builder.appIds;
    }

    /**
     * <p>
     * The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in the
     * specified stack.
     * </p>
     * 
     * @return The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps
     *         in the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code> returns a
     * description of the specified apps. Otherwise, it returns a description of every app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
     *         returns a description of the specified apps. Otherwise, it returns a description of every app.
     */
    public List<String> appIds() {
        return appIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(appIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppsRequest)) {
            return false;
        }
        DescribeAppsRequest other = (DescribeAppsRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(appIds(), other.appIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAppsRequest").add("StackId", stackId()).add("AppIds", appIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "AppIds":
            return Optional.of(clazz.cast(appIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeAppsRequest> {
        /**
         * <p>
         * The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in
         * the specified stack.
         * </p>
         * 
         * @param stackId
         *        The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the
         *        apps in the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         * returns a description of the specified apps. Otherwise, it returns a description of every app.
         * </p>
         * 
         * @param appIds
         *        An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         *        returns a description of the specified apps. Otherwise, it returns a description of every app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appIds(Collection<String> appIds);

        /**
         * <p>
         * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         * returns a description of the specified apps. Otherwise, it returns a description of every app.
         * </p>
         * 
         * @param appIds
         *        An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         *        returns a description of the specified apps. Otherwise, it returns a description of every app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appIds(String... appIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private List<String> appIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppsRequest model) {
            stackId(model.stackId);
            appIds(model.appIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getAppIds() {
            return appIds;
        }

        @Override
        public final Builder appIds(Collection<String> appIds) {
            this.appIds = StringsCopier.copy(appIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appIds(String... appIds) {
            appIds(Arrays.asList(appIds));
            return this;
        }

        public final void setAppIds(Collection<String> appIds) {
            this.appIds = StringsCopier.copy(appIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeAppsRequest build() {
            return new DescribeAppsRequest(this);
        }
    }
}
