/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.CommandMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Command implements StructuredPojo, ToCopyableBuilder<Command.Builder, Command> {
    private final String commandId;

    private final String instanceId;

    private final String deploymentId;

    private final String createdAt;

    private final String acknowledgedAt;

    private final String completedAt;

    private final String status;

    private final Integer exitCode;

    private final String logUrl;

    private final String type;

    private Command(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.deploymentId = builder.deploymentId;
        this.createdAt = builder.createdAt;
        this.acknowledgedAt = builder.acknowledgedAt;
        this.completedAt = builder.completedAt;
        this.status = builder.status;
        this.exitCode = builder.exitCode;
        this.logUrl = builder.logUrl;
        this.type = builder.type;
    }

    /**
     * <p>
     * The command ID.
     * </p>
     * 
     * @return The command ID.
     */
    public String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The ID of the instance where the command was executed.
     * </p>
     * 
     * @return The ID of the instance where the command was executed.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The command deployment ID.
     * </p>
     * 
     * @return The command deployment ID.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * Date and time when the command was run.
     * </p>
     * 
     * @return Date and time when the command was run.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date and time when the command was acknowledged.
     * </p>
     * 
     * @return Date and time when the command was acknowledged.
     */
    public String acknowledgedAt() {
        return acknowledgedAt;
    }

    /**
     * <p>
     * Date when the command completed.
     * </p>
     * 
     * @return Date when the command completed.
     */
    public String completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The command status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * failed
     * </p>
     * </li>
     * <li>
     * <p>
     * successful
     * </p>
     * </li>
     * <li>
     * <p>
     * skipped
     * </p>
     * </li>
     * <li>
     * <p>
     * pending
     * </p>
     * </li>
     * </ul>
     * 
     * @return The command status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         failed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         successful
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         skipped
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pending
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The command exit code.
     * </p>
     * 
     * @return The command exit code.
     */
    public Integer exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * The URL of the command log.
     * </p>
     * 
     * @return The URL of the command log.
     */
    public String logUrl() {
        return logUrl;
    }

    /**
     * <p>
     * The command type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>configure</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>execute_recipes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>install_dependencies</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>restart</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rollback</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>setup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stop</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>undeploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_custom_cookbooks</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_dependencies</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The command type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>configure</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>execute_recipes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>install_dependencies</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>restart</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rollback</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>setup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stop</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>undeploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_custom_cookbooks</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_dependencies</code>
     *         </p>
     *         </li>
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(acknowledgedAt(), other.acknowledgedAt()) && Objects.equals(completedAt(), other.completedAt())
                && Objects.equals(status(), other.status()) && Objects.equals(exitCode(), other.exitCode())
                && Objects.equals(logUrl(), other.logUrl()) && Objects.equals(type(), other.type());
    }

    @Override
    public String toString() {
        return ToString.builder("Command").add("CommandId", commandId()).add("InstanceId", instanceId())
                .add("DeploymentId", deploymentId()).add("CreatedAt", createdAt()).add("AcknowledgedAt", acknowledgedAt())
                .add("CompletedAt", completedAt()).add("Status", status()).add("ExitCode", exitCode()).add("LogUrl", logUrl())
                .add("Type", type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandId":
            return Optional.of(clazz.cast(commandId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "DeploymentId":
            return Optional.of(clazz.cast(deploymentId()));
        case "CreatedAt":
            return Optional.of(clazz.cast(createdAt()));
        case "AcknowledgedAt":
            return Optional.of(clazz.cast(acknowledgedAt()));
        case "CompletedAt":
            return Optional.of(clazz.cast(completedAt()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "ExitCode":
            return Optional.of(clazz.cast(exitCode()));
        case "LogUrl":
            return Optional.of(clazz.cast(logUrl()));
        case "Type":
            return Optional.of(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Command> {
        /**
         * <p>
         * The command ID.
         * </p>
         * 
         * @param commandId
         *        The command ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The ID of the instance where the command was executed.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance where the command was executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The command deployment ID.
         * </p>
         * 
         * @param deploymentId
         *        The command deployment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * Date and time when the command was run.
         * </p>
         * 
         * @param createdAt
         *        Date and time when the command was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Date and time when the command was acknowledged.
         * </p>
         * 
         * @param acknowledgedAt
         *        Date and time when the command was acknowledged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgedAt(String acknowledgedAt);

        /**
         * <p>
         * Date when the command completed.
         * </p>
         * 
         * @param completedAt
         *        Date when the command completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(String completedAt);

        /**
         * <p>
         * The command status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * failed
         * </p>
         * </li>
         * <li>
         * <p>
         * successful
         * </p>
         * </li>
         * <li>
         * <p>
         * skipped
         * </p>
         * </li>
         * <li>
         * <p>
         * pending
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The command status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        failed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        successful
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        skipped
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pending
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The command exit code.
         * </p>
         * 
         * @param exitCode
         *        The command exit code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * The URL of the command log.
         * </p>
         * 
         * @param logUrl
         *        The URL of the command log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUrl(String logUrl);

        /**
         * <p>
         * The command type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>configure</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>execute_recipes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>install_dependencies</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>restart</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rollback</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>setup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stop</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>undeploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_custom_cookbooks</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_dependencies</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The command type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>configure</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>execute_recipes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>install_dependencies</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>restart</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rollback</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>setup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stop</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>undeploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_custom_cookbooks</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_dependencies</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String commandId;

        private String instanceId;

        private String deploymentId;

        private String createdAt;

        private String acknowledgedAt;

        private String completedAt;

        private String status;

        private Integer exitCode;

        private String logUrl;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            commandId(model.commandId);
            instanceId(model.instanceId);
            deploymentId(model.deploymentId);
            createdAt(model.createdAt);
            acknowledgedAt(model.acknowledgedAt);
            completedAt(model.completedAt);
            status(model.status);
            exitCode(model.exitCode);
            logUrl(model.logUrl);
            type(model.type);
        }

        public final String getCommandId() {
            return commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getAcknowledgedAt() {
            return acknowledgedAt;
        }

        @Override
        public final Builder acknowledgedAt(String acknowledgedAt) {
            this.acknowledgedAt = acknowledgedAt;
            return this;
        }

        public final void setAcknowledgedAt(String acknowledgedAt) {
            this.acknowledgedAt = acknowledgedAt;
        }

        public final String getCompletedAt() {
            return completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getLogUrl() {
            return logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Command build() {
            return new Command(this);
        }
    }
}
