/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.opsworks.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * VolumeConfigurationMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class VolumeConfigurationMarshaller {

    private static final MarshallingInfo<String> MOUNTPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountPoint").build();
    private static final MarshallingInfo<Integer> RAIDLEVEL_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidLevel").build();
    private static final MarshallingInfo<Integer> NUMBEROFDISKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfDisks").build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").build();

    private static final VolumeConfigurationMarshaller INSTANCE = new VolumeConfigurationMarshaller();

    public static VolumeConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(VolumeConfiguration volumeConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (volumeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(volumeConfiguration.mountPoint(), MOUNTPOINT_BINDING);

            protocolMarshaller.marshall(volumeConfiguration.raidLevel(), RAIDLEVEL_BINDING);

            protocolMarshaller.marshall(volumeConfiguration.numberOfDisks(), NUMBEROFDISKS_BINDING);

            protocolMarshaller.marshall(volumeConfiguration.size(), SIZE_BINDING);

            protocolMarshaller.marshall(volumeConfiguration.volumeType(), VOLUMETYPE_BINDING);

            protocolMarshaller.marshall(volumeConfiguration.iops(), IOPS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
