/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.opsworks.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RaidArray JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RaidArrayUnmarshaller implements Unmarshaller<RaidArray, JsonUnmarshallerContext> {

    public RaidArray unmarshall(JsonUnmarshallerContext context) throws Exception {
        RaidArray.Builder raidArrayBuilder = RaidArray.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("RaidArrayId", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.raidArrayId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.instanceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RaidLevel", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.raidLevel(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("NumberOfDisks", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.numberOfDisks(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Size", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.size(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Device", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.device(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MountPoint", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.mountPoint(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.availabilityZone(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.createdAt(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StackId", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.stackId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VolumeType", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.volumeType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Iops", targetDepth)) {
                    context.nextToken();
                    raidArrayBuilder.iops(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return raidArrayBuilder.build();
    }

    private static final RaidArrayUnmarshaller INSTANCE = new RaidArrayUnmarshaller();

    public static RaidArrayUnmarshaller getInstance() {
        return INSTANCE;
    }
}
