/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.VolumeConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon EBS volume configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeConfiguration implements StructuredPojo, ToCopyableBuilder<VolumeConfiguration.Builder, VolumeConfiguration> {
    private final String mountPoint;

    private final Integer raidLevel;

    private final Integer numberOfDisks;

    private final Integer size;

    private final String volumeType;

    private final Integer iops;

    private VolumeConfiguration(BuilderImpl builder) {
        this.mountPoint = builder.mountPoint;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    /**
     * <p>
     * The volume mount point. For example "/dev/sdh".
     * </p>
     * 
     * @return The volume mount point. For example "/dev/sdh".
     */
    public String mountPoint() {
        return mountPoint;
    }

    /**
     * <p>
     * The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
     * </p>
     * 
     * @return The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
     */
    public Integer raidLevel() {
        return raidLevel;
    }

    /**
     * <p>
     * The number of disks in the volume.
     * </p>
     * 
     * @return The number of disks in the volume.
     */
    public Integer numberOfDisks() {
        return numberOfDisks;
    }

    /**
     * <p>
     * The volume size.
     * </p>
     * 
     * @return The volume size.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>standard</code> - Magnetic
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code> - Provisioned IOPS (SSD)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>gp2</code> - General Purpose (SSD)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The volume type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>standard</code> - Magnetic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code> - Provisioned IOPS (SSD)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>gp2</code> - General Purpose (SSD)
     *         </p>
     *         </li>
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * For PIOPS volumes, the IOPS per disk.
     * </p>
     * 
     * @return For PIOPS volumes, the IOPS per disk.
     */
    public Integer iops() {
        return iops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mountPoint() == null) ? 0 : mountPoint().hashCode());
        hashCode = 31 * hashCode + ((raidLevel() == null) ? 0 : raidLevel().hashCode());
        hashCode = 31 * hashCode + ((numberOfDisks() == null) ? 0 : numberOfDisks().hashCode());
        hashCode = 31 * hashCode + ((size() == null) ? 0 : size().hashCode());
        hashCode = 31 * hashCode + ((volumeType() == null) ? 0 : volumeType().hashCode());
        hashCode = 31 * hashCode + ((iops() == null) ? 0 : iops().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration) obj;
        if (other.mountPoint() == null ^ this.mountPoint() == null) {
            return false;
        }
        if (other.mountPoint() != null && !other.mountPoint().equals(this.mountPoint())) {
            return false;
        }
        if (other.raidLevel() == null ^ this.raidLevel() == null) {
            return false;
        }
        if (other.raidLevel() != null && !other.raidLevel().equals(this.raidLevel())) {
            return false;
        }
        if (other.numberOfDisks() == null ^ this.numberOfDisks() == null) {
            return false;
        }
        if (other.numberOfDisks() != null && !other.numberOfDisks().equals(this.numberOfDisks())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mountPoint() != null) {
            sb.append("MountPoint: ").append(mountPoint()).append(",");
        }
        if (raidLevel() != null) {
            sb.append("RaidLevel: ").append(raidLevel()).append(",");
        }
        if (numberOfDisks() != null) {
            sb.append("NumberOfDisks: ").append(numberOfDisks()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (volumeType() != null) {
            sb.append("VolumeType: ").append(volumeType()).append(",");
        }
        if (iops() != null) {
            sb.append("Iops: ").append(iops()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MountPoint":
            return Optional.of(clazz.cast(mountPoint()));
        case "RaidLevel":
            return Optional.of(clazz.cast(raidLevel()));
        case "NumberOfDisks":
            return Optional.of(clazz.cast(numberOfDisks()));
        case "Size":
            return Optional.of(clazz.cast(size()));
        case "VolumeType":
            return Optional.of(clazz.cast(volumeType()));
        case "Iops":
            return Optional.of(clazz.cast(iops()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeConfiguration> {
        /**
         * <p>
         * The volume mount point. For example "/dev/sdh".
         * </p>
         * 
         * @param mountPoint
         *        The volume mount point. For example "/dev/sdh".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoint(String mountPoint);

        /**
         * <p>
         * The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
         * </p>
         * 
         * @param raidLevel
         *        The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidLevel(Integer raidLevel);

        /**
         * <p>
         * The number of disks in the volume.
         * </p>
         * 
         * @param numberOfDisks
         *        The number of disks in the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDisks(Integer numberOfDisks);

        /**
         * <p>
         * The volume size.
         * </p>
         * 
         * @param size
         *        The volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>standard</code> - Magnetic
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code> - Provisioned IOPS (SSD)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>gp2</code> - General Purpose (SSD)
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeType
         *        The volume type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>standard</code> - Magnetic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code> - Provisioned IOPS (SSD)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>gp2</code> - General Purpose (SSD)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * For PIOPS volumes, the IOPS per disk.
         * </p>
         * 
         * @param iops
         *        For PIOPS volumes, the IOPS per disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);
    }

    static final class BuilderImpl implements Builder {
        private String mountPoint;

        private Integer raidLevel;

        private Integer numberOfDisks;

        private Integer size;

        private String volumeType;

        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            mountPoint(model.mountPoint);
            raidLevel(model.raidLevel);
            numberOfDisks(model.numberOfDisks);
            size(model.size);
            volumeType(model.volumeType);
            iops(model.iops);
        }

        public final String getMountPoint() {
            return mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final Integer getRaidLevel() {
            return raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        public final Integer getNumberOfDisks() {
            return numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }
    }
}
