/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.StackSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes the number of layers, instances, and apps in a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StackSummary implements StructuredPojo, ToCopyableBuilder<StackSummary.Builder, StackSummary> {
    private final String stackId;

    private final String name;

    private final String arn;

    private final Integer layersCount;

    private final Integer appsCount;

    private final InstancesCount instancesCount;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.layersCount = builder.layersCount;
        this.appsCount = builder.appsCount;
        this.instancesCount = builder.instancesCount;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The stack name.
     * </p>
     * 
     * @return The stack name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The stack's ARN.
     * </p>
     * 
     * @return The stack's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of layers.
     * </p>
     * 
     * @return The number of layers.
     */
    public Integer layersCount() {
        return layersCount;
    }

    /**
     * <p>
     * The number of apps.
     * </p>
     * 
     * @return The number of apps.
     */
    public Integer appsCount() {
        return appsCount;
    }

    /**
     * <p>
     * An <code>InstancesCount</code> object with the number of instances in each status.
     * </p>
     * 
     * @return An <code>InstancesCount</code> object with the number of instances in each status.
     */
    public InstancesCount instancesCount() {
        return instancesCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((layersCount() == null) ? 0 : layersCount().hashCode());
        hashCode = 31 * hashCode + ((appsCount() == null) ? 0 : appsCount().hashCode());
        hashCode = 31 * hashCode + ((instancesCount() == null) ? 0 : instancesCount().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.layersCount() == null ^ this.layersCount() == null) {
            return false;
        }
        if (other.layersCount() != null && !other.layersCount().equals(this.layersCount())) {
            return false;
        }
        if (other.appsCount() == null ^ this.appsCount() == null) {
            return false;
        }
        if (other.appsCount() != null && !other.appsCount().equals(this.appsCount())) {
            return false;
        }
        if (other.instancesCount() == null ^ this.instancesCount() == null) {
            return false;
        }
        if (other.instancesCount() != null && !other.instancesCount().equals(this.instancesCount())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (layersCount() != null) {
            sb.append("LayersCount: ").append(layersCount()).append(",");
        }
        if (appsCount() != null) {
            sb.append("AppsCount: ").append(appsCount()).append(",");
        }
        if (instancesCount() != null) {
            sb.append("InstancesCount: ").append(instancesCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Arn":
            return Optional.of(clazz.cast(arn()));
        case "LayersCount":
            return Optional.of(clazz.cast(layersCount()));
        case "AppsCount":
            return Optional.of(clazz.cast(appsCount()));
        case "InstancesCount":
            return Optional.of(clazz.cast(instancesCount()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StackSummary> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The stack name.
         * </p>
         * 
         * @param name
         *        The stack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The stack's ARN.
         * </p>
         * 
         * @param arn
         *        The stack's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of layers.
         * </p>
         * 
         * @param layersCount
         *        The number of layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layersCount(Integer layersCount);

        /**
         * <p>
         * The number of apps.
         * </p>
         * 
         * @param appsCount
         *        The number of apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsCount(Integer appsCount);

        /**
         * <p>
         * An <code>InstancesCount</code> object with the number of instances in each status.
         * </p>
         * 
         * @param instancesCount
         *        An <code>InstancesCount</code> object with the number of instances in each status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesCount(InstancesCount instancesCount);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String name;

        private String arn;

        private Integer layersCount;

        private Integer appsCount;

        private InstancesCount instancesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            stackId(model.stackId);
            name(model.name);
            arn(model.arn);
            layersCount(model.layersCount);
            appsCount(model.appsCount);
            instancesCount(model.instancesCount);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getLayersCount() {
            return layersCount;
        }

        @Override
        public final Builder layersCount(Integer layersCount) {
            this.layersCount = layersCount;
            return this;
        }

        public final void setLayersCount(Integer layersCount) {
            this.layersCount = layersCount;
        }

        public final Integer getAppsCount() {
            return appsCount;
        }

        @Override
        public final Builder appsCount(Integer appsCount) {
            this.appsCount = appsCount;
            return this;
        }

        public final void setAppsCount(Integer appsCount) {
            this.appsCount = appsCount;
        }

        public final InstancesCount.Builder getInstancesCount() {
            return instancesCount != null ? instancesCount.toBuilder() : null;
        }

        @Override
        public final Builder instancesCount(InstancesCount instancesCount) {
            this.instancesCount = instancesCount;
            return this;
        }

        public final void setInstancesCount(InstancesCount.BuilderImpl instancesCount) {
            this.instancesCount = instancesCount != null ? instancesCount.build() : null;
        }

        @Override
        public StackSummary build() {
            return new StackSummary(this);
        }
    }
}
