/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.SelfUserProfileMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a user's SSH information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SelfUserProfile implements StructuredPojo, ToCopyableBuilder<SelfUserProfile.Builder, SelfUserProfile> {
    private final String iamUserArn;

    private final String name;

    private final String sshUsername;

    private final String sshPublicKey;

    private SelfUserProfile(BuilderImpl builder) {
        this.iamUserArn = builder.iamUserArn;
        this.name = builder.name;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
    }

    /**
     * <p>
     * The user's IAM ARN.
     * </p>
     * 
     * @return The user's IAM ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * The user's name.
     * </p>
     * 
     * @return The user's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The user's SSH user name.
     * </p>
     * 
     * @return The user's SSH user name.
     */
    public String sshUsername() {
        return sshUsername;
    }

    /**
     * <p>
     * The user's SSH public key.
     * </p>
     * 
     * @return The user's SSH public key.
     */
    public String sshPublicKey() {
        return sshPublicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((iamUserArn() == null) ? 0 : iamUserArn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((sshUsername() == null) ? 0 : sshUsername().hashCode());
        hashCode = 31 * hashCode + ((sshPublicKey() == null) ? 0 : sshPublicKey().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfUserProfile)) {
            return false;
        }
        SelfUserProfile other = (SelfUserProfile) obj;
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.sshUsername() == null ^ this.sshUsername() == null) {
            return false;
        }
        if (other.sshUsername() != null && !other.sshUsername().equals(this.sshUsername())) {
            return false;
        }
        if (other.sshPublicKey() == null ^ this.sshPublicKey() == null) {
            return false;
        }
        if (other.sshPublicKey() != null && !other.sshPublicKey().equals(this.sshPublicKey())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (iamUserArn() != null) {
            sb.append("IamUserArn: ").append(iamUserArn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (sshUsername() != null) {
            sb.append("SshUsername: ").append(sshUsername()).append(",");
        }
        if (sshPublicKey() != null) {
            sb.append("SshPublicKey: ").append(sshPublicKey()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArn":
            return Optional.of(clazz.cast(iamUserArn()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "SshUsername":
            return Optional.of(clazz.cast(sshUsername()));
        case "SshPublicKey":
            return Optional.of(clazz.cast(sshPublicKey()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SelfUserProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SelfUserProfile> {
        /**
         * <p>
         * The user's IAM ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user's IAM ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * The user's name.
         * </p>
         * 
         * @param name
         *        The user's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The user's SSH user name.
         * </p>
         * 
         * @param sshUsername
         *        The user's SSH user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshUsername(String sshUsername);

        /**
         * <p>
         * The user's SSH public key.
         * </p>
         * 
         * @param sshPublicKey
         *        The user's SSH public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);
    }

    static final class BuilderImpl implements Builder {
        private String iamUserArn;

        private String name;

        private String sshUsername;

        private String sshPublicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfUserProfile model) {
            iamUserArn(model.iamUserArn);
            name(model.name);
            sshUsername(model.sshUsername);
            sshPublicKey(model.sshPublicKey);
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSshUsername() {
            return sshUsername;
        }

        @Override
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        public SelfUserProfile build() {
            return new SelfUserProfile(this);
        }
    }
}
