/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterVolumeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterVolumeRequest.Builder, RegisterVolumeRequest> {
    private final String ec2VolumeId;

    private final String stackId;

    private RegisterVolumeRequest(BuilderImpl builder) {
        this.ec2VolumeId = builder.ec2VolumeId;
        this.stackId = builder.stackId;
    }

    /**
     * <p>
     * The Amazon EBS volume ID.
     * </p>
     * 
     * @return The Amazon EBS volume ID.
     */
    public String ec2VolumeId() {
        return ec2VolumeId;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ec2VolumeId() == null) ? 0 : ec2VolumeId().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterVolumeRequest)) {
            return false;
        }
        RegisterVolumeRequest other = (RegisterVolumeRequest) obj;
        if (other.ec2VolumeId() == null ^ this.ec2VolumeId() == null) {
            return false;
        }
        if (other.ec2VolumeId() != null && !other.ec2VolumeId().equals(this.ec2VolumeId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ec2VolumeId() != null) {
            sb.append("Ec2VolumeId: ").append(ec2VolumeId()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ec2VolumeId":
            return Optional.of(clazz.cast(ec2VolumeId()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterVolumeRequest> {
        /**
         * <p>
         * The Amazon EBS volume ID.
         * </p>
         * 
         * @param ec2VolumeId
         *        The Amazon EBS volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2VolumeId(String ec2VolumeId);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);
    }

    static final class BuilderImpl implements Builder {
        private String ec2VolumeId;

        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterVolumeRequest model) {
            ec2VolumeId(model.ec2VolumeId);
            stackId(model.stackId);
        }

        public final String getEc2VolumeId() {
            return ec2VolumeId;
        }

        @Override
        public final Builder ec2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
            return this;
        }

        public final void setEc2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public RegisterVolumeRequest build() {
            return new RegisterVolumeRequest(this);
        }
    }
}
