/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterInstanceRequest.Builder, RegisterInstanceRequest> {
    private final String stackId;

    private final String hostname;

    private final String publicIp;

    private final String privateIp;

    private final String rsaPublicKey;

    private final String rsaPublicKeyFingerprint;

    private final InstanceIdentity instanceIdentity;

    private RegisterInstanceRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.hostname = builder.hostname;
        this.publicIp = builder.publicIp;
        this.privateIp = builder.privateIp;
        this.rsaPublicKey = builder.rsaPublicKey;
        this.rsaPublicKeyFingerprint = builder.rsaPublicKeyFingerprint;
        this.instanceIdentity = builder.instanceIdentity;
    }

    /**
     * <p>
     * The ID of the stack that the instance is to be registered with.
     * </p>
     * 
     * @return The ID of the stack that the instance is to be registered with.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The instance's hostname.
     * </p>
     * 
     * @return The instance's hostname.
     */
    public String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The instance's public IP address.
     * </p>
     * 
     * @return The instance's public IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The instance's private IP address.
     * </p>
     * 
     * @return The instance's private IP address.
     */
    public String privateIp() {
        return privateIp;
    }

    /**
     * <p>
     * The instances public RSA key. This key is used to encrypt communication between the instance and the service.
     * </p>
     * 
     * @return The instances public RSA key. This key is used to encrypt communication between the instance and the
     *         service.
     */
    public String rsaPublicKey() {
        return rsaPublicKey;
    }

    /**
     * <p>
     * The instances public RSA key fingerprint.
     * </p>
     * 
     * @return The instances public RSA key fingerprint.
     */
    public String rsaPublicKeyFingerprint() {
        return rsaPublicKeyFingerprint;
    }

    /**
     * <p>
     * An InstanceIdentity object that contains the instance's identity.
     * </p>
     * 
     * @return An InstanceIdentity object that contains the instance's identity.
     */
    public InstanceIdentity instanceIdentity() {
        return instanceIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((hostname() == null) ? 0 : hostname().hashCode());
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        hashCode = 31 * hashCode + ((privateIp() == null) ? 0 : privateIp().hashCode());
        hashCode = 31 * hashCode + ((rsaPublicKey() == null) ? 0 : rsaPublicKey().hashCode());
        hashCode = 31 * hashCode + ((rsaPublicKeyFingerprint() == null) ? 0 : rsaPublicKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + ((instanceIdentity() == null) ? 0 : instanceIdentity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceRequest)) {
            return false;
        }
        RegisterInstanceRequest other = (RegisterInstanceRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.privateIp() == null ^ this.privateIp() == null) {
            return false;
        }
        if (other.privateIp() != null && !other.privateIp().equals(this.privateIp())) {
            return false;
        }
        if (other.rsaPublicKey() == null ^ this.rsaPublicKey() == null) {
            return false;
        }
        if (other.rsaPublicKey() != null && !other.rsaPublicKey().equals(this.rsaPublicKey())) {
            return false;
        }
        if (other.rsaPublicKeyFingerprint() == null ^ this.rsaPublicKeyFingerprint() == null) {
            return false;
        }
        if (other.rsaPublicKeyFingerprint() != null && !other.rsaPublicKeyFingerprint().equals(this.rsaPublicKeyFingerprint())) {
            return false;
        }
        if (other.instanceIdentity() == null ^ this.instanceIdentity() == null) {
            return false;
        }
        if (other.instanceIdentity() != null && !other.instanceIdentity().equals(this.instanceIdentity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (hostname() != null) {
            sb.append("Hostname: ").append(hostname()).append(",");
        }
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        if (privateIp() != null) {
            sb.append("PrivateIp: ").append(privateIp()).append(",");
        }
        if (rsaPublicKey() != null) {
            sb.append("RsaPublicKey: ").append(rsaPublicKey()).append(",");
        }
        if (rsaPublicKeyFingerprint() != null) {
            sb.append("RsaPublicKeyFingerprint: ").append(rsaPublicKeyFingerprint()).append(",");
        }
        if (instanceIdentity() != null) {
            sb.append("InstanceIdentity: ").append(instanceIdentity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "Hostname":
            return Optional.of(clazz.cast(hostname()));
        case "PublicIp":
            return Optional.of(clazz.cast(publicIp()));
        case "PrivateIp":
            return Optional.of(clazz.cast(privateIp()));
        case "RsaPublicKey":
            return Optional.of(clazz.cast(rsaPublicKey()));
        case "RsaPublicKeyFingerprint":
            return Optional.of(clazz.cast(rsaPublicKeyFingerprint()));
        case "InstanceIdentity":
            return Optional.of(clazz.cast(instanceIdentity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterInstanceRequest> {
        /**
         * <p>
         * The ID of the stack that the instance is to be registered with.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack that the instance is to be registered with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The instance's hostname.
         * </p>
         * 
         * @param hostname
         *        The instance's hostname.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The instance's public IP address.
         * </p>
         * 
         * @param publicIp
         *        The instance's public IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The instance's private IP address.
         * </p>
         * 
         * @param privateIp
         *        The instance's private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIp(String privateIp);

        /**
         * <p>
         * The instances public RSA key. This key is used to encrypt communication between the instance and the service.
         * </p>
         * 
         * @param rsaPublicKey
         *        The instances public RSA key. This key is used to encrypt communication between the instance and the
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsaPublicKey(String rsaPublicKey);

        /**
         * <p>
         * The instances public RSA key fingerprint.
         * </p>
         * 
         * @param rsaPublicKeyFingerprint
         *        The instances public RSA key fingerprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsaPublicKeyFingerprint(String rsaPublicKeyFingerprint);

        /**
         * <p>
         * An InstanceIdentity object that contains the instance's identity.
         * </p>
         * 
         * @param instanceIdentity
         *        An InstanceIdentity object that contains the instance's identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdentity(InstanceIdentity instanceIdentity);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String hostname;

        private String publicIp;

        private String privateIp;

        private String rsaPublicKey;

        private String rsaPublicKeyFingerprint;

        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceRequest model) {
            stackId(model.stackId);
            hostname(model.hostname);
            publicIp(model.publicIp);
            privateIp(model.privateIp);
            rsaPublicKey(model.rsaPublicKey);
            rsaPublicKeyFingerprint(model.rsaPublicKeyFingerprint);
            instanceIdentity(model.instanceIdentity);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getPrivateIp() {
            return privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getRsaPublicKey() {
            return rsaPublicKey;
        }

        @Override
        public final Builder rsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
            return this;
        }

        public final void setRsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
        }

        public final String getRsaPublicKeyFingerprint() {
            return rsaPublicKeyFingerprint;
        }

        @Override
        public final Builder rsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
            return this;
        }

        public final void setRsaPublicKeyFingerprint(String rsaPublicKeyFingerprint) {
            this.rsaPublicKeyFingerprint = rsaPublicKeyFingerprint;
        }

        public final InstanceIdentity.Builder getInstanceIdentity() {
            return instanceIdentity != null ? instanceIdentity.toBuilder() : null;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        public final void setInstanceIdentity(InstanceIdentity.BuilderImpl instanceIdentity) {
            this.instanceIdentity = instanceIdentity != null ? instanceIdentity.build() : null;
        }

        @Override
        public RegisterInstanceRequest build() {
            return new RegisterInstanceRequest(this);
        }
    }
}
