/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.RaidArrayMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance's RAID array.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RaidArray implements StructuredPojo, ToCopyableBuilder<RaidArray.Builder, RaidArray> {
    private final String raidArrayId;

    private final String instanceId;

    private final String name;

    private final Integer raidLevel;

    private final Integer numberOfDisks;

    private final Integer size;

    private final String device;

    private final String mountPoint;

    private final String availabilityZone;

    private final String createdAt;

    private final String stackId;

    private final String volumeType;

    private final Integer iops;

    private RaidArray(BuilderImpl builder) {
        this.raidArrayId = builder.raidArrayId;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.device = builder.device;
        this.mountPoint = builder.mountPoint;
        this.availabilityZone = builder.availabilityZone;
        this.createdAt = builder.createdAt;
        this.stackId = builder.stackId;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    /**
     * <p>
     * The array ID.
     * </p>
     * 
     * @return The array ID.
     */
    public String raidArrayId() {
        return raidArrayId;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The array name.
     * </p>
     * 
     * @return The array name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
     * </p>
     * 
     * @return The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
     */
    public Integer raidLevel() {
        return raidLevel;
    }

    /**
     * <p>
     * The number of disks in the array.
     * </p>
     * 
     * @return The number of disks in the array.
     */
    public Integer numberOfDisks() {
        return numberOfDisks;
    }

    /**
     * <p>
     * The array's size.
     * </p>
     * 
     * @return The array's size.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The array's Linux device. For example /dev/mdadm0.
     * </p>
     * 
     * @return The array's Linux device. For example /dev/mdadm0.
     */
    public String device() {
        return device;
    }

    /**
     * <p>
     * The array's mount point.
     * </p>
     * 
     * @return The array's mount point.
     */
    public String mountPoint() {
        return mountPoint;
    }

    /**
     * <p>
     * The array's Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The array's Availability Zone. For more information, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * When the RAID array was created.
     * </p>
     * 
     * @return When the RAID array was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The volume type, standard or PIOPS.
     * </p>
     * 
     * @return The volume type, standard or PIOPS.
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * For PIOPS volumes, the IOPS per disk.
     * </p>
     * 
     * @return For PIOPS volumes, the IOPS per disk.
     */
    public Integer iops() {
        return iops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((raidArrayId() == null) ? 0 : raidArrayId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((raidLevel() == null) ? 0 : raidLevel().hashCode());
        hashCode = 31 * hashCode + ((numberOfDisks() == null) ? 0 : numberOfDisks().hashCode());
        hashCode = 31 * hashCode + ((size() == null) ? 0 : size().hashCode());
        hashCode = 31 * hashCode + ((device() == null) ? 0 : device().hashCode());
        hashCode = 31 * hashCode + ((mountPoint() == null) ? 0 : mountPoint().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((volumeType() == null) ? 0 : volumeType().hashCode());
        hashCode = 31 * hashCode + ((iops() == null) ? 0 : iops().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RaidArray)) {
            return false;
        }
        RaidArray other = (RaidArray) obj;
        if (other.raidArrayId() == null ^ this.raidArrayId() == null) {
            return false;
        }
        if (other.raidArrayId() != null && !other.raidArrayId().equals(this.raidArrayId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.raidLevel() == null ^ this.raidLevel() == null) {
            return false;
        }
        if (other.raidLevel() != null && !other.raidLevel().equals(this.raidLevel())) {
            return false;
        }
        if (other.numberOfDisks() == null ^ this.numberOfDisks() == null) {
            return false;
        }
        if (other.numberOfDisks() != null && !other.numberOfDisks().equals(this.numberOfDisks())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.mountPoint() == null ^ this.mountPoint() == null) {
            return false;
        }
        if (other.mountPoint() != null && !other.mountPoint().equals(this.mountPoint())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (raidArrayId() != null) {
            sb.append("RaidArrayId: ").append(raidArrayId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (raidLevel() != null) {
            sb.append("RaidLevel: ").append(raidLevel()).append(",");
        }
        if (numberOfDisks() != null) {
            sb.append("NumberOfDisks: ").append(numberOfDisks()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (mountPoint() != null) {
            sb.append("MountPoint: ").append(mountPoint()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (volumeType() != null) {
            sb.append("VolumeType: ").append(volumeType()).append(",");
        }
        if (iops() != null) {
            sb.append("Iops: ").append(iops()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RaidArrayId":
            return Optional.of(clazz.cast(raidArrayId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "RaidLevel":
            return Optional.of(clazz.cast(raidLevel()));
        case "NumberOfDisks":
            return Optional.of(clazz.cast(numberOfDisks()));
        case "Size":
            return Optional.of(clazz.cast(size()));
        case "Device":
            return Optional.of(clazz.cast(device()));
        case "MountPoint":
            return Optional.of(clazz.cast(mountPoint()));
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "CreatedAt":
            return Optional.of(clazz.cast(createdAt()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "VolumeType":
            return Optional.of(clazz.cast(volumeType()));
        case "Iops":
            return Optional.of(clazz.cast(iops()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RaidArrayMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RaidArray> {
        /**
         * <p>
         * The array ID.
         * </p>
         * 
         * @param raidArrayId
         *        The array ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayId(String raidArrayId);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The array name.
         * </p>
         * 
         * @param name
         *        The array name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
         * </p>
         * 
         * @param raidLevel
         *        The <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidLevel(Integer raidLevel);

        /**
         * <p>
         * The number of disks in the array.
         * </p>
         * 
         * @param numberOfDisks
         *        The number of disks in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDisks(Integer numberOfDisks);

        /**
         * <p>
         * The array's size.
         * </p>
         * 
         * @param size
         *        The array's size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The array's Linux device. For example /dev/mdadm0.
         * </p>
         * 
         * @param device
         *        The array's Linux device. For example /dev/mdadm0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * The array's mount point.
         * </p>
         * 
         * @param mountPoint
         *        The array's mount point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoint(String mountPoint);

        /**
         * <p>
         * The array's Availability Zone. For more information, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The array's Availability Zone. For more information, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * When the RAID array was created.
         * </p>
         * 
         * @param createdAt
         *        When the RAID array was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The volume type, standard or PIOPS.
         * </p>
         * 
         * @param volumeType
         *        The volume type, standard or PIOPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * For PIOPS volumes, the IOPS per disk.
         * </p>
         * 
         * @param iops
         *        For PIOPS volumes, the IOPS per disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);
    }

    static final class BuilderImpl implements Builder {
        private String raidArrayId;

        private String instanceId;

        private String name;

        private Integer raidLevel;

        private Integer numberOfDisks;

        private Integer size;

        private String device;

        private String mountPoint;

        private String availabilityZone;

        private String createdAt;

        private String stackId;

        private String volumeType;

        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(RaidArray model) {
            raidArrayId(model.raidArrayId);
            instanceId(model.instanceId);
            name(model.name);
            raidLevel(model.raidLevel);
            numberOfDisks(model.numberOfDisks);
            size(model.size);
            device(model.device);
            mountPoint(model.mountPoint);
            availabilityZone(model.availabilityZone);
            createdAt(model.createdAt);
            stackId(model.stackId);
            volumeType(model.volumeType);
            iops(model.iops);
        }

        public final String getRaidArrayId() {
            return raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getRaidLevel() {
            return raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        public final Integer getNumberOfDisks() {
            return numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getDevice() {
            return device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getMountPoint() {
            return mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public RaidArray build() {
            return new RaidArray(this);
        }
    }
}
