/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.PermissionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes stack or user permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Permission implements StructuredPojo, ToCopyableBuilder<Permission.Builder, Permission> {
    private final String stackId;

    private final String iamUserArn;

    private final Boolean allowSsh;

    private final Boolean allowSudo;

    private final String level;

    private Permission(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.iamUserArn = builder.iamUserArn;
        this.allowSsh = builder.allowSsh;
        this.allowSudo = builder.allowSudo;
        this.level = builder.level;
    }

    /**
     * <p>
     * A stack ID.
     * </p>
     * 
     * @return A stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more information about
     * IAM ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
     * Identifiers</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more information
     *         about IAM ARNs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * Whether the user can use SSH.
     * </p>
     * 
     * @return Whether the user can use SSH.
     */
    public Boolean allowSsh() {
        return allowSsh;
    }

    /**
     * <p>
     * Whether the user can use <b>sudo</b>.
     * </p>
     * 
     * @return Whether the user can use <b>sudo</b>.
     */
    public Boolean allowSudo() {
        return allowSudo;
    }

    /**
     * <p>
     * The user's permission level, which must be the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deny</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>show</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam_only</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on the permissions associated with these levels, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>
     * </p>
     * 
     * @return The user's permission level, which must be the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deny</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>show</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam_only</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on the permissions associated with these levels, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     *         Permissions</a>
     */
    public String level() {
        return level;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((iamUserArn() == null) ? 0 : iamUserArn().hashCode());
        hashCode = 31 * hashCode + ((allowSsh() == null) ? 0 : allowSsh().hashCode());
        hashCode = 31 * hashCode + ((allowSudo() == null) ? 0 : allowSudo().hashCode());
        hashCode = 31 * hashCode + ((level() == null) ? 0 : level().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        if (other.allowSsh() == null ^ this.allowSsh() == null) {
            return false;
        }
        if (other.allowSsh() != null && !other.allowSsh().equals(this.allowSsh())) {
            return false;
        }
        if (other.allowSudo() == null ^ this.allowSudo() == null) {
            return false;
        }
        if (other.allowSudo() != null && !other.allowSudo().equals(this.allowSudo())) {
            return false;
        }
        if (other.level() == null ^ this.level() == null) {
            return false;
        }
        if (other.level() != null && !other.level().equals(this.level())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (iamUserArn() != null) {
            sb.append("IamUserArn: ").append(iamUserArn()).append(",");
        }
        if (allowSsh() != null) {
            sb.append("AllowSsh: ").append(allowSsh()).append(",");
        }
        if (allowSudo() != null) {
            sb.append("AllowSudo: ").append(allowSudo()).append(",");
        }
        if (level() != null) {
            sb.append("Level: ").append(level()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "IamUserArn":
            return Optional.of(clazz.cast(iamUserArn()));
        case "AllowSsh":
            return Optional.of(clazz.cast(allowSsh()));
        case "AllowSudo":
            return Optional.of(clazz.cast(allowSudo()));
        case "Level":
            return Optional.of(clazz.cast(level()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PermissionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Permission> {
        /**
         * <p>
         * A stack ID.
         * </p>
         * 
         * @param stackId
         *        A stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more information
         * about IAM ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         * Identifiers</a>.
         * </p>
         * 
         * @param iamUserArn
         *        The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more
         *        information about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * Whether the user can use SSH.
         * </p>
         * 
         * @param allowSsh
         *        Whether the user can use SSH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSsh(Boolean allowSsh);

        /**
         * <p>
         * Whether the user can use <b>sudo</b>.
         * </p>
         * 
         * @param allowSudo
         *        Whether the user can use <b>sudo</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSudo(Boolean allowSudo);

        /**
         * <p>
         * The user's permission level, which must be the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deny</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>show</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam_only</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on the permissions associated with these levels, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
         * Permissions</a>
         * </p>
         * 
         * @param level
         *        The user's permission level, which must be the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deny</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>show</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam_only</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on the permissions associated with these levels, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
         *        Permissions</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level(String level);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String iamUserArn;

        private Boolean allowSsh;

        private Boolean allowSudo;

        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            stackId(model.stackId);
            iamUserArn(model.iamUserArn);
            allowSsh(model.allowSsh);
            allowSudo(model.allowSudo);
            level(model.level);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final Boolean getAllowSsh() {
            return allowSsh;
        }

        @Override
        public final Builder allowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public final void setAllowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
        }

        public final Boolean getAllowSudo() {
            return allowSudo;
        }

        @Override
        public final Builder allowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
            return this;
        }

        public final void setAllowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
        }

        public final String getLevel() {
            return level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public Permission build() {
            return new Permission(this);
        }
    }
}
