/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>GrantAccess</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GrantAccessResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GrantAccessResponse.Builder, GrantAccessResponse> {
    private final TemporaryCredential temporaryCredential;

    private GrantAccessResponse(BuilderImpl builder) {
        this.temporaryCredential = builder.temporaryCredential;
    }

    /**
     * <p>
     * A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by RDP clients,
     * such as the Microsoft Remote Desktop Connection.
     * </p>
     * 
     * @return A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by RDP
     *         clients, such as the Microsoft Remote Desktop Connection.
     */
    public TemporaryCredential temporaryCredential() {
        return temporaryCredential;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((temporaryCredential() == null) ? 0 : temporaryCredential().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantAccessResponse)) {
            return false;
        }
        GrantAccessResponse other = (GrantAccessResponse) obj;
        if (other.temporaryCredential() == null ^ this.temporaryCredential() == null) {
            return false;
        }
        if (other.temporaryCredential() != null && !other.temporaryCredential().equals(this.temporaryCredential())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (temporaryCredential() != null) {
            sb.append("TemporaryCredential: ").append(temporaryCredential()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemporaryCredential":
            return Optional.of(clazz.cast(temporaryCredential()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GrantAccessResponse> {
        /**
         * <p>
         * A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by RDP
         * clients, such as the Microsoft Remote Desktop Connection.
         * </p>
         * 
         * @param temporaryCredential
         *        A <code>TemporaryCredential</code> object that contains the data needed to log in to the instance by
         *        RDP clients, such as the Microsoft Remote Desktop Connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporaryCredential(TemporaryCredential temporaryCredential);
    }

    static final class BuilderImpl implements Builder {
        private TemporaryCredential temporaryCredential;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantAccessResponse model) {
            temporaryCredential(model.temporaryCredential);
        }

        public final TemporaryCredential.Builder getTemporaryCredential() {
            return temporaryCredential != null ? temporaryCredential.toBuilder() : null;
        }

        @Override
        public final Builder temporaryCredential(TemporaryCredential temporaryCredential) {
            this.temporaryCredential = temporaryCredential;
            return this;
        }

        public final void setTemporaryCredential(TemporaryCredential.BuilderImpl temporaryCredential) {
            this.temporaryCredential = temporaryCredential != null ? temporaryCredential.build() : null;
        }

        @Override
        public GrantAccessResponse build() {
            return new GrantAccessResponse(this);
        }
    }
}
