/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GrantAccessRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GrantAccessRequest.Builder, GrantAccessRequest> {
    private final String instanceId;

    private final Integer validForInMinutes;

    private GrantAccessRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.validForInMinutes = builder.validForInMinutes;
    }

    /**
     * <p>
     * The instance's AWS OpsWorks Stacks ID.
     * </p>
     * 
     * @return The instance's AWS OpsWorks Stacks ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period, the
     * user will no longer be able to use the credentials to log in. If the user is logged in at the time, he or she
     * automatically will be logged out.
     * </p>
     * 
     * @return The length of time (in minutes) that the grant is valid. When the grant expires at the end of this
     *         period, the user will no longer be able to use the credentials to log in. If the user is logged in at the
     *         time, he or she automatically will be logged out.
     */
    public Integer validForInMinutes() {
        return validForInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((validForInMinutes() == null) ? 0 : validForInMinutes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantAccessRequest)) {
            return false;
        }
        GrantAccessRequest other = (GrantAccessRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.validForInMinutes() == null ^ this.validForInMinutes() == null) {
            return false;
        }
        if (other.validForInMinutes() != null && !other.validForInMinutes().equals(this.validForInMinutes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (validForInMinutes() != null) {
            sb.append("ValidForInMinutes: ").append(validForInMinutes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "ValidForInMinutes":
            return Optional.of(clazz.cast(validForInMinutes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GrantAccessRequest> {
        /**
         * <p>
         * The instance's AWS OpsWorks Stacks ID.
         * </p>
         * 
         * @param instanceId
         *        The instance's AWS OpsWorks Stacks ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period,
         * the user will no longer be able to use the credentials to log in. If the user is logged in at the time, he or
         * she automatically will be logged out.
         * </p>
         * 
         * @param validForInMinutes
         *        The length of time (in minutes) that the grant is valid. When the grant expires at the end of this
         *        period, the user will no longer be able to use the credentials to log in. If the user is logged in at
         *        the time, he or she automatically will be logged out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validForInMinutes(Integer validForInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private Integer validForInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantAccessRequest model) {
            instanceId(model.instanceId);
            validForInMinutes(model.validForInMinutes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getValidForInMinutes() {
            return validForInMinutes;
        }

        @Override
        public final Builder validForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
            return this;
        }

        public final void setValidForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
        }

        @Override
        public GrantAccessRequest build() {
            return new GrantAccessRequest(this);
        }
    }
}
