/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeVolumesRequest.Builder, DescribeVolumesRequest> {
    private final String instanceId;

    private final String stackId;

    private final String raidArrayId;

    private final List<String> volumeIds;

    private DescribeVolumesRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.raidArrayId = builder.raidArrayId;
        this.volumeIds = builder.volumeIds;
    }

    /**
     * <p>
     * The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes
     * associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the
     *         volumes associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A stack ID. The action describes the stack's registered Amazon EBS volumes.
     * </p>
     * 
     * @return A stack ID. The action describes the stack's registered Amazon EBS volumes.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes
     * associated with the specified RAID array.
     * </p>
     * 
     * @return The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the
     *         volumes associated with the specified RAID array.
     */
    public String raidArrayId() {
        return raidArrayId;
    }

    /**
     * <p>
     * Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the
     * specified volumes. Otherwise, it returns a description of every volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of
     *         the specified volumes. Otherwise, it returns a description of every volume.
     */
    public List<String> volumeIds() {
        return volumeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((raidArrayId() == null) ? 0 : raidArrayId().hashCode());
        hashCode = 31 * hashCode + ((volumeIds() == null) ? 0 : volumeIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesRequest)) {
            return false;
        }
        DescribeVolumesRequest other = (DescribeVolumesRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.raidArrayId() == null ^ this.raidArrayId() == null) {
            return false;
        }
        if (other.raidArrayId() != null && !other.raidArrayId().equals(this.raidArrayId())) {
            return false;
        }
        if (other.volumeIds() == null ^ this.volumeIds() == null) {
            return false;
        }
        if (other.volumeIds() != null && !other.volumeIds().equals(this.volumeIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (raidArrayId() != null) {
            sb.append("RaidArrayId: ").append(raidArrayId()).append(",");
        }
        if (volumeIds() != null) {
            sb.append("VolumeIds: ").append(volumeIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "RaidArrayId":
            return Optional.of(clazz.cast(raidArrayId()));
        case "VolumeIds":
            return Optional.of(clazz.cast(volumeIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVolumesRequest> {
        /**
         * <p>
         * The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the volumes
         * associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the
         *        volumes associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A stack ID. The action describes the stack's registered Amazon EBS volumes.
         * </p>
         * 
         * @param stackId
         *        A stack ID. The action describes the stack's registered Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the
         * volumes associated with the specified RAID array.
         * </p>
         * 
         * @param raidArrayId
         *        The RAID array ID. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the
         *        volumes associated with the specified RAID array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayId(String raidArrayId);

        /**
         * <p>
         * Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the
         * specified volumes. Otherwise, it returns a description of every volume.
         * </p>
         * 
         * @param volumeIds
         *        Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions
         *        of the specified volumes. Otherwise, it returns a description of every volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions of the
         * specified volumes. Otherwise, it returns a description of every volume.
         * </p>
         * 
         * @param volumeIds
         *        Am array of volume IDs. If you use this parameter, <code>DescribeVolumes</code> returns descriptions
         *        of the specified volumes. Otherwise, it returns a description of every volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String stackId;

        private String raidArrayId;

        private List<String> volumeIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesRequest model) {
            instanceId(model.instanceId);
            stackId(model.stackId);
            raidArrayId(model.raidArrayId);
            volumeIds(model.volumeIds);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getRaidArrayId() {
            return raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        public final Collection<String> getVolumeIds() {
            return volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = StringsCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = StringsCopier.copy(volumeIds);
        }

        @Override
        public DescribeVolumesRequest build() {
            return new DescribeVolumesRequest(this);
        }
    }
}
