/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStacksRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeStacksRequest.Builder, DescribeStacksRequest> {
    private final List<String> stackIds;

    private DescribeStacksRequest(BuilderImpl builder) {
        this.stackIds = builder.stackIds;
    }

    /**
     * <p>
     * An array of stack IDs that specify the stacks to be described. If you omit this parameter,
     * <code>DescribeStacks</code> returns a description of every stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of stack IDs that specify the stacks to be described. If you omit this parameter,
     *         <code>DescribeStacks</code> returns a description of every stack.
     */
    public List<String> stackIds() {
        return stackIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackIds() == null) ? 0 : stackIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksRequest)) {
            return false;
        }
        DescribeStacksRequest other = (DescribeStacksRequest) obj;
        if (other.stackIds() == null ^ this.stackIds() == null) {
            return false;
        }
        if (other.stackIds() != null && !other.stackIds().equals(this.stackIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackIds() != null) {
            sb.append("StackIds: ").append(stackIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackIds":
            return Optional.of(clazz.cast(stackIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStacksRequest> {
        /**
         * <p>
         * An array of stack IDs that specify the stacks to be described. If you omit this parameter,
         * <code>DescribeStacks</code> returns a description of every stack.
         * </p>
         * 
         * @param stackIds
         *        An array of stack IDs that specify the stacks to be described. If you omit this parameter,
         *        <code>DescribeStacks</code> returns a description of every stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIds(Collection<String> stackIds);

        /**
         * <p>
         * An array of stack IDs that specify the stacks to be described. If you omit this parameter,
         * <code>DescribeStacks</code> returns a description of every stack.
         * </p>
         * 
         * @param stackIds
         *        An array of stack IDs that specify the stacks to be described. If you omit this parameter,
         *        <code>DescribeStacks</code> returns a description of every stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIds(String... stackIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> stackIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksRequest model) {
            stackIds(model.stackIds);
        }

        public final Collection<String> getStackIds() {
            return stackIds;
        }

        @Override
        public final Builder stackIds(Collection<String> stackIds) {
            this.stackIds = StringsCopier.copy(stackIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackIds(String... stackIds) {
            stackIds(Arrays.asList(stackIds));
            return this;
        }

        public final void setStackIds(Collection<String> stackIds) {
            this.stackIds = StringsCopier.copy(stackIds);
        }

        @Override
        public DescribeStacksRequest build() {
            return new DescribeStacksRequest(this);
        }
    }
}
